/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.spring.ws.util;

import com.seeyon.ctp.common.AppContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.context.ApplicationContext;
import org.wso2.spring.ws.SpringAxisConfiguration;
import org.wso2.spring.ws.WebServices;

public class Utils {
    private static final String ADVISED_FIELD_NAME = "advised";
    private static final String CLASS_JDK_DYNAMIC_AOP_PROXY = "org.springframework.aop.framework.JdkDynamicAopProxy";

    public static SpringAxisConfiguration getAxisConfigfromAppContext(ApplicationContext appCtx) throws ServletException {
        return (SpringAxisConfiguration)Utils.getBeanfromAppContext(appCtx, SpringAxisConfiguration.class);
    }

    public static WebServices getServicesfromAppContext(ApplicationContext appCtx) throws ServletException {
        return (WebServices)Utils.getBeanfromAppContext(appCtx, WebServices.class);
    }

    protected static Object getBeanfromAppContext(ApplicationContext appCtx, Class clazz) throws ServletException {
        Map configMap = AppContext.getBeansOfType(clazz);
        if (configMap.size() > 1) {
            throw new ServletException("More than one " + clazz.getCanonicalName() + " beans present");
        }
        Iterator it = configMap.values().iterator();
        Object obj = it.next();
        return obj;
    }

    public static Class getTargetClassFromJdkDynamicAopProxy(Object candidate) {
        try {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(candidate);
            if (!invocationHandler.getClass().getName().equals(CLASS_JDK_DYNAMIC_AOP_PROXY)) {
                return candidate.getClass();
            }
            AdvisedSupport advised = (AdvisedSupport)new DirectFieldAccessor((Object)invocationHandler).getPropertyValue(ADVISED_FIELD_NAME);
            Class targetClass = advised.getTargetClass();
            if (Proxy.isProxyClass(targetClass)) {
                Object target = advised.getTargetSource().getTarget();
                return Utils.getTargetClassFromJdkDynamicAopProxy(target);
            }
            return targetClass;
        }
        catch (Exception e) {
            return candidate.getClass();
        }
    }
}

