/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import com.seeyon.ctp.dubbo.DubboHttpSession;
import com.seeyon.ctp.session.CTPSessionRepository;
import javax.servlet.http.HttpSession;
import org.springframework.session.Session;
import org.springframework.session.web.http.ExpiringSessionHttpSession;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class CTPDelegatingFilterProxy
extends DelegatingFilterProxy {
    private static WebApplicationContext wac;
    private String[] locations = new String[]{"/WEB-INF/spring.xml"};
    private static CTPSessionRepository sessionRepository;

    protected WebApplicationContext findWebApplicationContext() {
        if (wac == null) {
            XmlWebApplicationContext context = new XmlWebApplicationContext();
            context.setConfigLocations(this.locations);
            context.setServletContext(this.getServletContext());
            context.refresh();
            wac = context;
        }
        return wac;
    }

    public static HttpSession getSession(String sessionId) {
        Session session;
        if (wac == null) {
            return null;
        }
        if (sessionRepository == null) {
            sessionRepository = (CTPSessionRepository)wac.getBean("sessionRepository");
        }
        return (session = sessionRepository.getSession(sessionId)) == null ? null : new DubboHttpSession(session);
    }

    public static void saveSession(HttpSession session) {
        if (session == null) {
            return;
        }
        if (sessionRepository == null) {
            sessionRepository = (CTPSessionRepository)wac.getBean("sessionRepository");
        }
        Session s = session instanceof DubboHttpSession ? ((DubboHttpSession)session).getSession() : ((ExpiringSessionHttpSession)session).getSession();
        sessionRepository.save(s);
    }

    static {
        sessionRepository = null;
    }
}

