/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.v3x.common.ajax.impl;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.v3x.common.ajax.AJAXException;
import com.seeyon.v3x.common.ajax.AJAXParameter;
import com.seeyon.v3x.common.ajax.AJAXRequest;
import com.seeyon.v3x.common.ajax.impl.AJAXParameterImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;

public class AJAXRequestImpl
implements AJAXRequest {
    protected static final Log log = CtpLogFactory.getLog(AJAXRequestImpl.class);
    private final HttpServletRequest request;
    private Class[] types;
    private Object[] values;
    private String serviceName;
    private String methodName;
    private HttpServletResponse response;

    public AJAXRequestImpl(HttpServletRequest request, HttpServletResponse response, String serviceName, String methodName) throws AJAXException {
        this.request = request;
        this.response = response;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.parseRequestArguments();
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public HttpServletRequest getServletRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getServletResponse() {
        return this.response;
    }

    private void parseRequestArguments() throws AJAXException {
        boolean isNeedEncoder = true;
        String requestBodyEncoding = this.request.getCharacterEncoding();
        if ("UTF-8".equalsIgnoreCase(requestBodyEncoding)) {
            isNeedEncoder = false;
        }
        try {
            Enumeration e = this.request.getParameterNames();
            if (e != null) {
                HashMap<Integer, AJAXParameterImpl> pm = new HashMap<Integer, AJAXParameterImpl>();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (!name.startsWith("P_")) continue;
                    String[] nameKeys = name.split("_");
                    int index = Integer.parseInt(nameKeys[1]) - 1;
                    String type = nameKeys[2];
                    String[] values = null;
                    String value = null;
                    if (nameKeys.length == 3) {
                        value = this.request.getParameter(name);
                    } else if (nameKeys.length == 4) {
                        type = type + "[]";
                        values = this.request.getParameterValues(name);
                    } else {
                        if (nameKeys.length != 5 || !"N".equals(nameKeys[4])) continue;
                        type = type + "[]";
                        values = new String[]{};
                    }
                    AJAXParameterImpl ajaxParam = new AJAXParameterImpl(type, value, values, isNeedEncoder);
                    pm.put(index, ajaxParam);
                }
                ArrayList indexs = new ArrayList(pm.keySet());
                Collections.sort(indexs);
                int len = indexs.size();
                this.types = new Class[len];
                this.values = new Object[len];
                for (int i = 0; i < len; ++i) {
                    AJAXParameter p = (AJAXParameter)pm.get(i);
                    this.types[i] = p.getClassName();
                    this.values[i] = p.getValue();
                }
            }
        }
        catch (Exception ex) {
            throw new AJAXException("Errors were encountered parsing request parameters for the AJAX service " + this.serviceName, ex);
        }
    }

    @Override
    public Class[] getTypes() {
        return this.types;
    }

    @Override
    public Object[] getValues() {
        return this.values;
    }
}

