/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.statistics;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;

public class SeeyonAnalyser {
    private static Log logger = CtpLogFactory.getLog(SeeyonAnalyser.class);
    private static final String SEEYON_ANALYSIS = "seeyon.method.invoke.analysis";
    private static boolean cacheSizeAnalyzeOn = false;
    private static boolean methodInvokeAnalyzeOn = false;
    private static boolean performanceAnalysisOn = false;
    private static Method sizeAnalyzeMethod;

    public static boolean isCacheSizeAnalyzeOn() {
        return cacheSizeAnalyzeOn;
    }

    public static boolean isMethodInvokeAnalyzeOn() {
        return methodInvokeAnalyzeOn;
    }

    public static boolean isPerformanceAnalysisOn() {
        return performanceAnalysisOn;
    }

    public static long sizeOf(Object obj) {
        long size = 0L;
        if (sizeAnalyzeMethod != null) {
            try {
                size = (Long)sizeAnalyzeMethod.invoke(null, obj);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"IllegalAccessException", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)"InvocationTargetException", (Throwable)e);
            }
        }
        return size;
    }

    static {
        try {
            Class<?> statisticCalss = Class.forName("com.seeyon.statistics.SeeyonStatistics");
            Method method = statisticCalss.getMethod("isStatisticsOn", new Class[0]);
            sizeAnalyzeMethod = statisticCalss.getMethod("fullSizeOf", Object.class);
            cacheSizeAnalyzeOn = (Boolean)method.invoke(null, new Object[0]);
            method = statisticCalss.getMethod("isPerformanceAnalysisOn", new Class[0]);
            performanceAnalysisOn = (Boolean)method.invoke(null, new Object[0]);
            methodInvokeAnalyzeOn = "on".equals(System.getProperty(SEEYON_ANALYSIS, "off"));
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"\u672a\u914d\u7f6eA8\u7f13\u5b58\u5927\u5c0f\u53ca\u8c03\u7528\u65b9\u6cd5\u7edf\u8ba1\u652f\u6301");
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

