/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.statistics;

import com.seeyon.statistics.MethodInvokeInfo;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodInvokeStatistics {
    private static final Map<String, MethodInvokeInfo> methodInvokeMap = new ConcurrentHashMap<String, MethodInvokeInfo>();
    private static final Object synObj = new Object();
    private static final ThreadLocal<Map<String, Long>> methodRquestMap = new ThreadLocal();

    public static void startMethodInvoke(String method) {
        Map<String, Long> requestMap = methodRquestMap.get();
        if (requestMap == null) {
            requestMap = new HashMap<String, Long>();
            methodRquestMap.set(requestMap);
        }
        requestMap.put(method, System.currentTimeMillis());
    }

    public static void finishMethodInvoke(String method) {
        Map<String, Long> invokeMap = methodRquestMap.get();
        if (invokeMap == null || invokeMap.get(method) == null) {
            return;
        }
        long startTime = invokeMap.get(method);
        invokeMap.remove(method);
        long timeConsume = System.currentTimeMillis() - startTime;
        MethodInvokeInfo invokeInfo = methodInvokeMap.get(method);
        if (invokeInfo == null) {
            invokeInfo = new MethodInvokeInfo(method);
            methodInvokeMap.put(method, invokeInfo);
        }
        invokeInfo.addOneInvoke(startTime, timeConsume);
    }

    public static MethodInvokeInfo[] getSortedInvokes() {
        MethodInvokeInfo[] invodeInfos = new MethodInvokeInfo[methodInvokeMap.size()];
        int i = 0;
        for (Map.Entry<String, MethodInvokeInfo> entry : methodInvokeMap.entrySet()) {
            if (i == invodeInfos.length) break;
            invodeInfos[i++] = entry.getValue();
        }
        Arrays.sort(invodeInfos, new Comparator<MethodInvokeInfo>(){

            @Override
            public int compare(MethodInvokeInfo o1, MethodInvokeInfo o2) {
                return o1.getMaxTime() > o2.getMaxTime() ? -1 : (o1.getMaxTime() < o2.getMaxTime() ? 1 : 0);
            }
        });
        return invodeInfos;
    }

    public static MethodInvokeInfo[] getSortedInvokeNums() {
        MethodInvokeInfo[] invodeInfos = new MethodInvokeInfo[methodInvokeMap.size()];
        int i = 0;
        for (Map.Entry<String, MethodInvokeInfo> entry : methodInvokeMap.entrySet()) {
            if (i == invodeInfos.length) break;
            invodeInfos[i++] = entry.getValue();
        }
        Arrays.sort(invodeInfos, new Comparator<MethodInvokeInfo>(){

            @Override
            public int compare(MethodInvokeInfo o1, MethodInvokeInfo o2) {
                return o1.getInvokeNum() > o2.getInvokeNum() ? -1 : (o1.getInvokeNum() < o2.getInvokeNum() ? 1 : 0);
            }
        });
        return invodeInfos;
    }

    public static void clear() {
        methodInvokeMap.clear();
    }

    public static void removeThreadLocal() {
        methodRquestMap.remove();
    }
}

