/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.model;

import com.seeyon.ctp.util.json.model.JSONComplex;
import com.seeyon.ctp.util.json.model.JSONValue;
import com.seeyon.ctp.util.json.parser.impl.ParserUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class JSONObject
extends JSONComplex {
    private Map map = new LinkedHashMap();

    @Override
    public int size() {
        return this.map.size();
    }

    public Map getValue() {
        return this.map;
    }

    public String toString() {
        StringBuilder lBuf = new StringBuilder();
        lBuf.append("JSONObject(").append(this.getLine()).append(':').append(this.getCol()).append(")[");
        Iterator lIter = this.map.keySet().iterator();
        while (lIter.hasNext()) {
            String lKey = (String)lIter.next();
            lBuf.append(lKey).append(':').append(this.map.get(lKey).toString());
            if (!lIter.hasNext()) continue;
            lBuf.append(", ");
        }
        lBuf.append(']');
        return lBuf.toString();
    }

    @Override
    protected String render(boolean aPretty, String aIndent) {
        StringBuilder lBuf = new StringBuilder();
        Iterator lKeyIter = this.map.keySet().iterator();
        if (aPretty) {
            lBuf.append(aIndent).append("{\n");
            String lIndent = aIndent + "   ";
            String lIndent2 = aIndent + "      ";
            while (lKeyIter.hasNext()) {
                String lKey = (String)lKeyIter.next();
                JSONValue jsonValue = (JSONValue)this.map.get(lKey);
                lBuf.append(lIndent).append(ParserUtil.render(lKey, false, ""));
                if (jsonValue.isSimple()) {
                    lBuf.append(" : ").append(jsonValue.render(false, ""));
                } else {
                    lBuf.append(" :\n").append(jsonValue.render(true, lIndent2));
                }
                if (lKeyIter.hasNext()) {
                    lBuf.append(",\n");
                    continue;
                }
                lBuf.append("\n");
            }
            lBuf.append(aIndent).append("}");
        } else {
            lBuf.append("{");
            while (lKeyIter.hasNext()) {
                String lKey = (String)lKeyIter.next();
                JSONValue jsonValue = (JSONValue)this.map.get(lKey);
                lBuf.append(ParserUtil.render(lKey, false, "")).append(":").append(jsonValue.render(false));
                if (!lKeyIter.hasNext()) continue;
                lBuf.append(",");
            }
            lBuf.append(aIndent).append("}");
        }
        return lBuf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONObject that = (JSONObject)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean containsKey(String aKey) {
        return this.map.containsKey(aKey);
    }

    public JSONValue get(String aKey) {
        return (JSONValue)this.map.get(aKey);
    }

    @Override
    public Object strip() {
        LinkedHashMap lResult = new LinkedHashMap();
        for (Object lKey : this.map.keySet()) {
            JSONValue jsonValue = (JSONValue)this.map.get(lKey);
            lResult.put(lKey, jsonValue.strip());
        }
        return lResult;
    }
}

