/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.ClassUtil;
import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.model.JSONDecimal;
import com.seeyon.ctp.util.json.model.JSONString;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.math.BigDecimal;

public class FloatMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Float.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (aValue.isString()) {
            try {
                return ClassUtil.CASE(((JSONString)aValue).getValue(), Float.class);
            }
            catch (NumberFormatException e) {
                throw new MapperException("FloatMapper cannot map value: " + ((JSONString)aValue).getValue());
            }
        }
        if (aValue.isDecimal()) {
            return new Float(((JSONDecimal)aValue).getValue().floatValue());
        }
        throw new MapperException("FloatMapper cannot map: " + aValue.getClass().getName());
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        if (!Float.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("FloatMapper cannot map: " + aPojo.getClass().getName());
        }
        return new JSONDecimal(new BigDecimal(aPojo.toString()));
    }
}

