/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.TimeZoneUtil;
import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.impl.AbstractMapper;
import com.seeyon.ctp.util.json.model.JSONString;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateMapper
extends AbstractMapper {
    @Override
    public Class getHelpedClass() {
        return Date.class;
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        String dateString = Datetimes.format((Date)aPojo, "yyyy-MM-dd HH:mm", TimeZoneUtil.getCustomerTimeZone());
        return new JSONString(dateString);
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        return DateMapper.fromISO8601(((JSONString)aValue).getValue().trim(), true);
    }

    public static String toRFC3339(Date date) {
        return DateMapper.toRFC3339(date, true);
    }

    public static String toRFC3339(Date date, boolean timezoneIgnored) {
        String dateString = Datetimes.format(date, "yyyy-MM-dd HH:mm", TimeZoneUtil.getCustomerTimeZone());
        return dateString;
    }

    public static Date fromISO8601(String timestampString) throws MapperException {
        return DateMapper.fromISO8601(timestampString, true);
    }

    public static Date fromISO8601(String timestampString, boolean timezoneIgnored) throws MapperException {
        Pattern timePattern;
        Matcher timeMatcher;
        if (timestampString == null || timestampString.trim().length() < 1) {
            throw new MapperException("time stamp string can't be empty.");
        }
        timestampString = timestampString.trim();
        GregorianCalendar calendar = new GregorianCalendar();
        String separator = " ";
        if (timestampString.indexOf("T") != -1) {
            separator = "T";
        }
        String[] dateAndTime = timestampString.split(separator);
        String dateString = dateAndTime[0];
        String timeString = null;
        if (dateAndTime.length > 1) {
            timeString = dateAndTime[1];
        }
        if ((timeMatcher = (timePattern = Pattern.compile("^(\\d{4})((-?(\\d{2})(-?(\\d{2}))?)|(-?(\\d{3}))|(-?W(\\d{2})(-?([1-7]))?))?$")).matcher(dateString)).find()) {
            int dayOfWeek;
            int year = Integer.parseInt(timeMatcher.group(1));
            int month = timeMatcher.group(4) == null ? 0 : Integer.parseInt(timeMatcher.group(4));
            int dayOfMonth = timeMatcher.group(6) == null ? 1 : Integer.parseInt(timeMatcher.group(6));
            int dayOfYear = timeMatcher.group(8) == null ? -1 : Integer.parseInt(timeMatcher.group(8));
            int week = timeMatcher.group(10) == null ? -1 : Integer.parseInt(timeMatcher.group(10));
            int n = dayOfWeek = timeMatcher.group(12) == null ? 2 : Integer.parseInt(timeMatcher.group(12)) + 1;
            if (dayOfWeek == 8) {
                dayOfWeek = 1;
                ++week;
            }
            calendar.set(1, year);
            if (week != -1) {
                calendar.set(3, week);
                calendar.set(7, dayOfWeek);
            } else if (dayOfYear != -1) {
                calendar.set(6, dayOfYear);
            } else {
                calendar.set(2, month - 1);
                calendar.set(5, dayOfMonth);
            }
        } else {
            throw new MapperException("invalid date string:" + dateString);
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        int milliSecond = 0;
        String timezoneString = null;
        String localTimeString = timeString;
        if (timeString != null) {
            Pattern localTimePattern;
            Matcher localTimeMatcher;
            Pattern timezonePattern = Pattern.compile("(([-+])(\\d{2})(:?(\\d{2}))?)$");
            Matcher timezoneMatcher = timezonePattern.matcher(timeString);
            if (timezoneMatcher.find()) {
                timezoneString = timezoneMatcher.group(0);
                localTimeString = timeString.substring(0, timeString.length() - timezoneString.length());
            }
            if ((localTimeMatcher = (localTimePattern = Pattern.compile("^(\\d{2})(:?(\\d{2})(:?(\\d{2})(.(\\d+))?)?)?$")).matcher(localTimeString)).find()) {
                if (localTimeMatcher.group(1) != null) {
                    hour = Integer.parseInt(localTimeMatcher.group(1));
                }
                if (localTimeMatcher.group(3) != null) {
                    minute = Integer.parseInt(localTimeMatcher.group(3));
                }
                if (localTimeMatcher.group(5) != null) {
                    second = Integer.parseInt(localTimeMatcher.group(5));
                }
                if (localTimeMatcher.group(7) != null) {
                    milliSecond = (int)(Float.parseFloat("0." + localTimeMatcher.group(7)) * 1000.0f);
                }
            }
        }
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milliSecond);
        if (timezoneString != null && !timezoneIgnored) {
            TimeZone timeZone = TimeZone.getTimeZone("GMT" + timezoneString);
            calendar.setTimeZone(timeZone);
            return calendar.getTime();
        }
        return calendar.getTime();
    }
}

