/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.seeyon.ctp.common.code.KeyEnum;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class KeyEnumDeserializer
implements ObjectDeserializer {
    private final Map<Type, EnumCache> cache = new HashMap<Type, EnumCache>();

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        if (!this.cache.containsKey(type)) {
            this.cache.put(type, new EnumCache(type));
        }
        try {
            JSONLexer lexer = parser.getLexer();
            if (lexer.token() == 2) {
                Integer value = lexer.intValue();
                lexer.nextToken(16);
                Object e = this.cache.get(type).getValue(value);
                if (e == null) {
                    // empty if block
                }
                return (T)e;
            }
            if (lexer.token() == 4) {
                String strVal = lexer.stringVal();
                lexer.nextToken(16);
                if (strVal.length() == 0) {
                    return null;
                }
                return null;
            }
            if (lexer.token() == 8) {
                Object value = null;
                lexer.nextToken(16);
                return null;
            }
            Object value = parser.parse();
            throw new JSONException("parse enum  error, value : " + value);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public int getFastMatchToken() {
        return 2;
    }

    class EnumCache {
        private final Map<Integer, KeyEnum> keyMap = new HashMap<Integer, KeyEnum>();
        private final Map<String, Enum> nameMap = new HashMap<String, Enum>();

        public EnumCache(Type type) {
            Class enumClass = (Class)type;
            this.init(enumClass);
        }

        private void init(Class<?> enumClass) {
            try {
                Object[] values;
                Method valueMethod = enumClass.getMethod("values", new Class[0]);
                for (Object value : values = (Object[])valueMethod.invoke(null, new Object[0])) {
                    KeyEnum ke = (KeyEnum)value;
                    this.keyMap.put(ke.getKey(), ke);
                    if (!value.getClass().isEnum()) continue;
                    Enum e = (Enum)((Object)ke);
                    this.nameMap.put(e.name(), e);
                }
            }
            catch (Exception ex) {
                throw new JSONException("init enum values error, ");
            }
        }

        public Object getValue(int key) {
            return this.keyMap.get(key);
        }

        public Object getValue(String name) {
            return this.nameMap.get(name);
        }
    }
}

