/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.html;

import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.html.HTMLConvertManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

public final class HTMLConvertManagerImpl
implements HTMLConvertManager {
    private static final Log log = CtpLogFactory.getLog(HTMLConvertManagerImpl.class);
    private String htmlTemplate = null;
    private String path = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHtmlTemplatePath(String htmlTemplatePath) {
        StringBuilder sb = new StringBuilder();
        FileInputStream input = null;
        InputStreamReader reader = null;
        BufferedReader breader = null;
        try {
            input = new FileInputStream(htmlTemplatePath);
            reader = new InputStreamReader(input);
            breader = new BufferedReader(reader);
            String line = breader.readLine();
            while (line != null) {
                sb.append(line);
                line = breader.readLine();
            }
            breader.close();
        }
        catch (Exception e) {
            try {
                log.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(breader);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly(breader);
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Reader)breader);
        this.htmlTemplate = sb.toString();
    }

    public void setHtmlDestPath(String path) {
        this.path = Strings.getCanonicalPathAndCreate(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveHTML(Map<String, String> data, String destFilename) {
        Properties props = new Properties();
        props.putAll(data);
        String html = SystemProperties.interpolateHelper(this.htmlTemplate, props);
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.path + File.separator + destFilename + ".html");
            IOUtils.write((String)html, (OutputStream)output, (String)"UTF-8");
            IOUtils.closeQuietly((OutputStream)output);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(output);
        }
        return false;
    }
}

