/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.cache;

import com.seeyon.ctp.util.cache.ClickDetail;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClickCache {
    private long dataId;
    private int clickNum;
    private int clickTotal;
    private Timestamp clickTime;
    private List<ClickDetail> details = new ArrayList<ClickDetail>();
    private Object mutex = new Object();

    public ClickCache(long dataId, int clickTotal) {
        this.dataId = dataId;
        this.clickTotal = clickTotal;
        this.clickNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ClickDetail> getClickDetails() {
        ArrayList<ClickDetail> set = new ArrayList<ClickDetail>();
        Object object = this.mutex;
        synchronized (object) {
            set.addAll(this.details);
            this.details.clear();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ClickDetail> getClickDetailsNoClear() {
        ArrayList<ClickDetail> set = new ArrayList<ClickDetail>();
        Object object = this.mutex;
        synchronized (object) {
            set.addAll(this.details);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(ClickDetail detail) {
        Object object = this.mutex;
        synchronized (object) {
            ++this.clickNum;
            ++this.clickTotal;
            this.clickTime = detail.getClickDate();
            this.details.add(detail);
        }
    }

    public int getClickNum() {
        return this.clickNum;
    }

    public void setClickNum(int clickNum) {
        this.clickNum = clickNum;
    }

    public long getDataId() {
        return this.dataId;
    }

    public void setDataId(long dataId) {
        this.dataId = dataId;
    }

    public int getClickTotal() {
        return this.clickTotal;
    }

    public void setClickTotal(int clickTotal) {
        this.clickTotal = clickTotal;
    }

    public Timestamp getClickTime() {
        return this.clickTime;
    }

    public void setClickTime(Timestamp clickTime) {
        this.clickTime = clickTime;
    }
}

