/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.array;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.RandomAccess;

public class LoopArray<T>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 654316399983932600L;
    private int size = 0;
    private int pos = 0;
    private int maxSize;
    protected transient T[] elements;
    private Class<?> componentType;

    public LoopArray(T[] buffer) {
        this.maxSize = buffer.length;
        this.elements = buffer;
        this.componentType = buffer.getClass().getComponentType();
    }

    public void add(T a) {
        ++this.size;
        if (this.pos < this.maxSize) {
            this.elements[this.pos++] = a;
        } else {
            this.pos = 1;
            this.elements[0] = a;
        }
    }

    public void add(T[] a) {
        int len;
        if (a != null && (len = a.length) > 0) {
            this.size += len;
            if (a.length > this.maxSize) {
                System.arraycopy(a, 0, this.elements, 0, this.maxSize);
                this.pos = this.maxSize;
            } else {
                int x = this.maxSize - this.pos;
                if (x > len) {
                    System.arraycopy(a, 0, this.elements, this.pos, len);
                    this.pos += len;
                } else {
                    int len1 = len - x;
                    System.arraycopy(a, 0, this.elements, this.pos, x);
                    System.arraycopy(a, x, this.elements, 0, len1);
                    this.pos = len1;
                }
            }
        }
    }

    public int size() {
        return this.size >= this.maxSize ? this.maxSize : this.pos;
    }

    public int getPosition() {
        return this.pos;
    }

    private T[] makeArray(int len) {
        return (Object[])Array.newInstance(this.componentType, len);
    }

    public T[] getArray() {
        if (this.size == 0) {
            return null;
        }
        if (this.size < this.maxSize) {
            T[] rst = this.makeArray(this.pos);
            System.arraycopy(this.elements, 0, rst, 0, this.pos);
            return rst;
        }
        T[] rst = this.makeArray(this.maxSize);
        int len = this.maxSize - this.pos;
        System.arraycopy(this.elements, this.pos, rst, 0, len);
        System.arraycopy(this.elements, 0, rst, len, this.pos);
        return rst;
    }

    public T getFirst() {
        if (this.size == 0) {
            return null;
        }
        if (this.size < this.maxSize) {
            return this.elements[0];
        }
        return this.elements[this.pos];
    }

    public T getLast() {
        if (this.size == 0) {
            return null;
        }
        if (this.pos > 0) {
            return this.elements[this.pos - 1];
        }
        return this.elements[this.maxSize - 1];
    }

    public T[] getFirst(int length) {
        if (this.size == 0) {
            return null;
        }
        if (this.size < this.maxSize) {
            if (this.pos < length) {
                length = this.pos;
            }
            T[] rst = this.makeArray(length);
            System.arraycopy(this.elements, 0, rst, 0, length);
            return rst;
        }
        if (length > this.maxSize) {
            T[] rst = this.makeArray(this.maxSize);
            int len = this.maxSize - this.pos;
            System.arraycopy(this.elements, this.pos, rst, 0, len);
            System.arraycopy(this.elements, 0, rst, len, this.pos);
            return rst;
        }
        int len = this.maxSize - this.pos;
        T[] rst = this.makeArray(length);
        if (len > length) {
            System.arraycopy(this.elements, this.pos, rst, 0, length);
        } else {
            System.arraycopy(this.elements, this.pos, rst, 0, len);
            System.arraycopy(this.elements, 0, rst, len, length - len);
        }
        return rst;
    }

    public T[] getLast(int length) {
        if (this.size == 0) {
            return null;
        }
        if (this.pos > length) {
            T[] rst = this.makeArray(length);
            System.arraycopy(this.elements, this.pos - length, rst, 0, length);
            return rst;
        }
        if (this.size < this.maxSize) {
            T[] rst = this.makeArray(this.pos);
            System.arraycopy(this.elements, 0, rst, 0, this.pos);
            return rst;
        }
        if (length > this.maxSize) {
            T[] rst = this.makeArray(this.maxSize);
            int len = this.maxSize - this.pos;
            System.arraycopy(this.elements, this.pos, rst, 0, len);
            System.arraycopy(this.elements, 0, rst, len, this.pos);
            return rst;
        }
        T[] rst = this.makeArray(length);
        int len = length - this.pos;
        System.arraycopy(this.elements, this.maxSize - len, rst, 0, len);
        System.arraycopy(this.elements, 0, rst, len, this.pos);
        return rst;
    }

    public T[] getArray(int end, int length) {
        if (this.size == 0) {
            return null;
        }
        if (end > length) {
            T[] rst = this.makeArray(length);
            System.arraycopy(this.elements, end - length, rst, 0, length);
            return rst;
        }
        if (this.size < this.maxSize) {
            T[] rst = this.makeArray(end);
            System.arraycopy(this.elements, 0, rst, 0, end);
            return rst;
        }
        if (length > this.maxSize) {
            T[] rst = this.makeArray(this.maxSize);
            int len = this.maxSize - end;
            System.arraycopy(this.elements, end, rst, 0, len);
            System.arraycopy(this.elements, 0, rst, len, end);
            return rst;
        }
        T[] rst = this.makeArray(length);
        int len = length - end;
        System.arraycopy(this.elements, this.maxSize - len, rst, 0, len);
        System.arraycopy(this.elements, 0, rst, len, end);
        return rst;
    }

    public T[] subList(int start, int end) {
        if (this.size == 0) {
            return null;
        }
        if (end > start) {
            int len = end - start;
            T[] rst = this.makeArray(len);
            System.arraycopy(this.elements, start, rst, 0, len);
            return rst;
        }
        int len1 = this.maxSize - start;
        int len = len1 + end;
        T[] rst = this.makeArray(len);
        System.arraycopy(this.elements, start, rst, 0, len1);
        System.arraycopy(this.elements, 0, rst, len1, end);
        return rst;
    }

    public T[] subList(int start, int end, int length) {
        if (this.size == 0) {
            return null;
        }
        if (end > start) {
            int len = end - start;
            if (len > length) {
                len = length;
                start = end - len;
            }
            T[] rst = this.makeArray(len);
            System.arraycopy(this.elements, start, rst, 0, len);
            return rst;
        }
        if (end >= length) {
            T[] rst = this.makeArray(length);
            System.arraycopy(this.elements, end - length, rst, 0, length);
            return rst;
        }
        int len1 = this.maxSize - start;
        int i = length - end;
        if (len1 > i) {
            len1 = i;
            start = this.maxSize - len1;
        }
        int len = len1 + end;
        T[] rst = this.makeArray(len);
        System.arraycopy(this.elements, start, rst, 0, len1);
        System.arraycopy(this.elements, 0, rst, len1, end);
        return rst;
    }
}

