/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public final class ZipUtil {
    private static final String SEPARATOR = "/";
    private static final String OUTPUT_ENCODING = Charset.defaultCharset().toString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(Collection<File> files, File zipFile) throws IOException, FileNotFoundException {
        byte[] b = new byte[1024];
        ZipOutputStream zipout = null;
        try {
            zipout = new ZipOutputStream((OutputStream)new FileOutputStream(zipFile));
            zipout.setEncoding("GBK");
            for (File file : files) {
                if (!file.exists()) {
                    throw new FileNotFoundException("\ufffd\u013c\ufffd [" + file.getAbsolutePath() + "] \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                }
                String filename = file.getName();
                if (!file.isFile()) continue;
                FileInputStream in = new FileInputStream(file);
                try {
                    ZipEntry ze = new ZipEntry(filename);
                    ze.setUnixMode(644);
                    zipout.putNextEntry(ze);
                    int len = 0;
                    while ((len = in.read(b)) > 0) {
                        zipout.write(b, 0, len);
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex1) {
            throw ex1;
        }
        finally {
            if (zipout != null) {
                try {
                    zipout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void zip(File[] files, File zipFile) throws IOException, FileNotFoundException {
        ZipUtil.zip(Arrays.asList(files), zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(File file, ZipOutputStream zipout, String baseFileName) throws IOException, FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("\ufffd\u013c\ufffd [" + file.getAbsolutePath() + "] \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        String filename = file.getName();
        if (Strings.isNotBlank(baseFileName)) {
            filename = baseFileName + SEPARATOR + filename;
        }
        if (file.isFile()) {
            byte[] b = new byte[1024];
            FileInputStream in = new FileInputStream(file);
            try {
                zipout.putNextEntry(new ZipEntry(filename));
                int len = 0;
                while ((len = in.read(b)) > 0) {
                    zipout.write(b, 0, len);
                }
            }
            finally {
                in.close();
            }
        } else if (file.isDirectory()) {
            ZipEntry entry = new ZipEntry(filename + SEPARATOR);
            zipout.putNextEntry(entry);
            File[] fl = file.listFiles();
            if (fl != null && fl.length > 0) {
                for (File file2 : fl) {
                    ZipUtil.zip(file2, zipout, filename);
                }
            }
        }
    }

    public static void zip(File directory, File zipFile, boolean isIncludeCurrentDirectory) throws FileNotFoundException, IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + "is not a directory.");
        }
        ZipOutputStream zipout = null;
        try {
            zipout = new ZipOutputStream((OutputStream)new FileOutputStream(zipFile));
            zipout.setEncoding(OUTPUT_ENCODING);
            if (isIncludeCurrentDirectory) {
                ZipUtil.zip(directory, zipout, null);
            } else {
                File[] fl = directory.listFiles();
                if (fl != null && fl.length > 0) {
                    for (File file2 : fl) {
                        ZipUtil.zip(file2, zipout, null);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e1) {
            throw e1;
        }
        finally {
            if (zipout != null) {
                try {
                    zipout.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void zip(File directory, File zipFile, boolean isIncludeCurrentDirectory, String encode, String comment) throws FileNotFoundException, IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + "is not a directory.");
        }
        ZipOutputStream zipout = null;
        try {
            zipout = new ZipOutputStream((OutputStream)new FileOutputStream(zipFile));
            zipout.setEncoding(encode);
            zipout.setComment(comment);
            if (isIncludeCurrentDirectory) {
                ZipUtil.zip(directory, zipout, null);
            } else {
                File[] fl = directory.listFiles();
                if (fl != null && fl.length > 0) {
                    for (File file2 : fl) {
                        ZipUtil.zip(file2, zipout, null);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e1) {
            throw e1;
        }
        finally {
            if (zipout != null) {
                try {
                    zipout.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static List<File> unzip(File zipFile, File directory) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        ArrayList<File> list = new ArrayList<File>();
        ZipFile z = new ZipFile(zipFile, OUTPUT_ENCODING);
        ZipUtil.unzip(directory, list, z);
        return list;
    }

    public static List<File> unzipBycode(File zipFile, File directory, String encode) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        ArrayList<File> list = new ArrayList<File>();
        ZipFile z = new ZipFile(zipFile, encode);
        ZipUtil.unzip(directory, list, z);
        return list;
    }

    private static void unzip(File directory, List<File> list, ZipFile z) throws IOException, ZipException, FileNotFoundException {
        Enumeration e = z.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)e.nextElement();
            File file = new File(directory.getAbsolutePath() + File.separator + entry.getName());
            String canonicalDestinationDirPath = directory.getCanonicalPath();
            String canonicalDestinationFile = file.getCanonicalPath();
            if (!canonicalDestinationFile.startsWith(canonicalDestinationDirPath)) {
                throw new UnsupportedOperationException("Entry is outside of the target dir: " + canonicalDestinationFile);
            }
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            InputStream in = z.getInputStream(entry);
            FileOutputStream out = new FileOutputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
            list.add(file);
        }
        z.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uncompressRequest(String source, String compressType, String responseEncoding, Log logger) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)compressType) && StringUtils.isNotBlank((CharSequence)source) && ("GZIP".equalsIgnoreCase(compressType) || "ZIP".equalsIgnoreCase(compressType))) {
            ByteArrayInputStream sourceIn = null;
            InputStream uncompressIn = null;
            try {
                sourceIn = new ByteArrayInputStream(source.getBytes("iso-8859-1"));
                if ("GZIP".equalsIgnoreCase(compressType)) {
                    uncompressIn = new GZIPInputStream(sourceIn);
                } else if ("ZIP".equalsIgnoreCase(compressType)) {
                    uncompressIn = new ZipInputStream(sourceIn);
                }
                result = IOUtils.toString((InputStream)uncompressIn, (String)responseEncoding);
            }
            catch (Exception e) {
                logger.error((Object)"compress data error.", (Throwable)e);
            }
            finally {
                try {
                    if (uncompressIn != null) {
                        uncompressIn.close();
                    }
                    if (sourceIn != null) {
                        sourceIn.close();
                    }
                }
                catch (Exception ex) {
                    logger.warn((Object)"", (Throwable)ex);
                }
            }
        } else {
            result = source;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compressResponse(String source, String compressType, String responseEncoding, Log logger) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)compressType) && StringUtils.isNotBlank((CharSequence)source) && ("GZIP".equalsIgnoreCase(compressType) || "ZIP".equalsIgnoreCase(compressType))) {
            ByteArrayOutputStream sourceOut = new ByteArrayOutputStream();
            OutputStream compressOut = null;
            try {
                if ("GZIP".equalsIgnoreCase(compressType)) {
                    compressOut = new GZIPOutputStream(sourceOut);
                } else if ("ZIP".equalsIgnoreCase(compressType)) {
                    compressOut = new ZipOutputStream((OutputStream)sourceOut);
                } else {
                    String string = null;
                    return string;
                }
                compressOut.write(source.getBytes(responseEncoding));
                compressOut.close();
                result = sourceOut.toString("iso-8859-1");
            }
            catch (Exception e) {
                logger.error((Object)"compress data error.", (Throwable)e);
            }
            finally {
                try {
                    if (compressOut != null) {
                        compressOut.close();
                    }
                    if (sourceOut != null) {
                        sourceOut.close();
                    }
                }
                catch (Exception ex) {
                    logger.warn((Object)"", (Throwable)ex);
                }
            }
        } else {
            result = source;
        }
        return result;
    }

    public static void zip(File directory, File target, String password, boolean isIncludeCurrentDirectory) throws net.lingala.zip4j.exception.ZipException {
        net.lingala.zip4j.core.ZipFile zipFile = new net.lingala.zip4j.core.ZipFile(target);
        ZipParameters parameters = ZipUtil.initZipParameters(password);
        if (isIncludeCurrentDirectory) {
            if (directory.isDirectory()) {
                zipFile.addFolder(directory, parameters);
            } else {
                zipFile.addFile(directory, parameters);
            }
        } else {
            ArrayList<File> l = new ArrayList<File>();
            File[] fl = directory.listFiles();
            if (fl != null && fl.length > 0) {
                for (File file2 : fl) {
                    l.add(file2);
                }
            }
            ZipUtil.zip(l, target, password);
        }
    }

    public static void zip(Collection<File> files, File target, String password) throws net.lingala.zip4j.exception.ZipException {
        net.lingala.zip4j.core.ZipFile zipFile = new net.lingala.zip4j.core.ZipFile(target);
        ZipParameters parameters = ZipUtil.initZipParameters(password);
        for (File file : files) {
            if (file.isDirectory()) {
                zipFile.addFolder(file, parameters);
                continue;
            }
            zipFile.addFile(file, parameters);
        }
    }

    private static ZipParameters initZipParameters(String password) {
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        parameters.setEncryptFiles(true);
        parameters.setEncryptionMethod(0);
        parameters.setPassword(password);
        return parameters;
    }

    public static List<File> unzip(File file, File directory, String password) throws net.lingala.zip4j.exception.ZipException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String basePath = directory.getAbsolutePath();
        net.lingala.zip4j.core.ZipFile zipFile = new net.lingala.zip4j.core.ZipFile(file);
        if (zipFile.isEncrypted()) {
            zipFile.setPassword(password);
        }
        zipFile.extractAll(basePath);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basePath);
        ds.setIncludes(new String[]{"*/*.*"});
        ds.scan();
        String[] files = ds.getIncludedFiles();
        ArrayList<File> list = new ArrayList<File>(files.length);
        for (int i = 0; i < files.length; ++i) {
            File f = new File(basePath + SEPARATOR + files[i]);
            list.add(f);
        }
        return list;
    }
}

