/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XXEUtil {
    private static final Log LOG = LogFactory.getLog(XXEUtil.class);

    public static void prevent(XMLReader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }

    public static void prevent(XMLInputFactory factory) {
        if (factory == null) {
            return;
        }
        try {
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }

    public static void prevent(SAXReader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }

    public static void prevent(SAXBuilder builder) {
        if (builder == null) {
            return;
        }
        try {
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }

    public static void prevent(SAXTransformerFactory sf) {
        if (sf == null) {
            return;
        }
        try {
            sf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            sf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }

    public static void prevent(DocumentBuilderFactory dbf) {
        if (dbf == null) {
            return;
        }
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }

    public static Document safeParseText(String text) throws DocumentException {
        Document result = null;
        SAXReader reader = new SAXReader();
        XXEUtil.prevent(reader);
        String encoding = XXEUtil.getEncoding(text);
        InputSource source = new InputSource(new StringReader(text));
        source.setEncoding(encoding);
        result = reader.read(source);
        if (result.getXMLEncoding() == null) {
            result.setXMLEncoding(encoding);
        }
        return result;
    }

    private static String getEncoding(String text) {
        String result = null;
        String xml = text.trim();
        if (xml.startsWith("<?xml")) {
            int end = xml.indexOf("?>");
            String sub = xml.substring(0, end);
            StringTokenizer tokens = new StringTokenizer(sub, " =\"'");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!"encoding".equals(token)) continue;
                if (!tokens.hasMoreTokens()) break;
                result = tokens.nextToken();
                break;
            }
        }
        return result;
    }
}

