/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.util.JDBCAgent;
import com.vdurmont.emoji.EmojiParser;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.net.util.IPAddressUtil;

public final class Strings {
    private static final Log LOG = LogFactory.getLog(Strings.class);
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    private static final int INDEX_NOT_FOUND = -1;
    private static String serverName = System.getProperty("ctp.server.name");
    public static final String REGEX_DIGIT = "^([-]?[\\d]*)[\\d]+$";
    public static final String REGEX_WORD = "^[\\w]+$";
    public static final String REGEX_I18NKEY = "^[\\w.-]+$";
    public static final String REGEX_NOTCHARACTER = "[\\x00-\\xff]*[^\\x00-\\xff]+[\\x00-\\xff]*";
    public static final String REGEX_DECIMAL_EXCLUDEPLUS = "^([-]?)([\\d]*)([.]?)(\\d+)$";
    private static final String UNICODE_SEPERATER = "\\u";
    private static final int UNICODE_CHAR_NUMBER = 6;
    private static final String[] UNICODE_FORMAT_ARRAY = new String[]{"", "0", "00", "000"};
    private static final int UNICODE_STRING_LENGTH = 4;
    private static final String ILLEGAL_CHARACTER_SET = "$&\"'\n\r\\<>%{}[]";
    private static String pattern = "<(?i)(script|textarea|form|bgSound|base|applet|select|!--|iframe|frameset|frame|meta|html|link|title|body|head|input)";
    private static Pattern p1 = Pattern.compile(pattern);
    private static String patternOn = "(<.*\\s)(?i)(on\\w+)(\\s*=)";
    private static Pattern p2 = Pattern.compile(patternOn);

    public static String getLimitLengthString(String content, int len, String symbol) {
        if (len < 0) {
            return content;
        }
        try {
            return Strings.getLimitLengthString(content, null, len, symbol);
        }
        catch (UnsupportedEncodingException e) {
            return content;
        }
    }

    public static String getLimitLengthString(String content, String charsetName, int len, String symbol) throws UnsupportedEncodingException {
        String sym = symbol;
        if (content == null || content.length() == 0) {
            return content;
        }
        if (sym == null) {
            sym = "";
        }
        int counterOfDoubleByte = 0;
        byte[] b = charsetName == null ? content.getBytes("GBK") : content.getBytes(charsetName);
        if (b.length <= len) {
            return content;
        }
        if (len > sym.length()) {
            len -= sym.length();
        }
        for (int i = 0; i < len; ++i) {
            if (b[i] >= 0) continue;
            ++counterOfDoubleByte;
        }
        if (counterOfDoubleByte % 2 != 0) {
            --len;
        }
        byte[] newBytes = new byte[len];
        System.arraycopy(b, 0, newBytes, 0, len);
        if (charsetName == null) {
            return new String(newBytes, "GBK") + sym;
        }
        return new String(newBytes, charsetName) + sym;
    }

    public static String getSafeLimitLengthString(String content, int len, String symbol) {
        byte[] b;
        if (len < 0) {
            return content;
        }
        int reInt = 0;
        String reStr = "";
        if (content == null) {
            return "";
        }
        if (len >= content.getBytes().length) {
            return content;
        }
        char[] tempChar = content.toCharArray();
        for (int kk = 0; kk < tempChar.length && len > reInt; reInt += b.length, ++kk) {
            String s1 = String.valueOf(tempChar[kk]);
            b = s1.getBytes();
            reStr = reStr + tempChar[kk];
        }
        if (len == reInt || len == reInt - 1 || len == reInt - 2) {
            reStr = reStr + symbol;
        }
        return reStr;
    }

    public static String toHTML(String text) {
        return Strings.toHTML(text, true);
    }

    public static String toHTML(String text, boolean isEscapeSpace) {
        if (text == null || "".equals(text)) {
            return "";
        }
        char[] content = new char[text.length()];
        text.getChars(0, text.length(), content, 0);
        StringBuilder result = new StringBuilder();
        block10: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '\n': {
                    result.append("<br/>");
                    continue block10;
                }
                case '\r': {
                    continue block10;
                }
                case '<': {
                    result.append("&lt;");
                    continue block10;
                }
                case '>': {
                    result.append("&gt;");
                    continue block10;
                }
                case '&': {
                    result.append("&amp;");
                    continue block10;
                }
                case '\'': {
                    result.append("&#039;");
                    continue block10;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block10;
                }
                case ' ': {
                    if (isEscapeSpace) {
                        result.append("&nbsp;");
                        continue block10;
                    }
                    result.append(content[i]);
                    continue block10;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String toHTMLescpapeSC(String text, boolean isEscapeSpace) {
        if (text == null || "".equals(text)) {
            return "";
        }
        char[] content = new char[text.length()];
        text.getChars(0, text.length(), content, 0);
        StringBuilder result = new StringBuilder();
        block10: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '\n': {
                    result.append("<br/>");
                    continue block10;
                }
                case '\r': {
                    continue block10;
                }
                case '<': {
                    result.append("&lt;");
                    continue block10;
                }
                case '>': {
                    result.append("&gt;");
                    continue block10;
                }
                case '&': {
                    if (isEscapeSpace) {
                        result.append("&nbsp;");
                        continue block10;
                    }
                    result.append("&amp;");
                    continue block10;
                }
                case '\'': {
                    if (isEscapeSpace) {
                        result.append("&nbsp;");
                        continue block10;
                    }
                    result.append("&#039;");
                    continue block10;
                }
                case '\"': {
                    if (isEscapeSpace) {
                        result.append("&nbsp;");
                        continue block10;
                    }
                    result.append("&quot;");
                    continue block10;
                }
                case ' ': {
                    if (isEscapeSpace) {
                        result.append("&nbsp;");
                        continue block10;
                    }
                    result.append(content[i]);
                    continue block10;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String toHTMLescapeRN(String text, boolean isEscapeSpace) {
        if (text == null || "".equals(text)) {
            return "";
        }
        char[] content = new char[text.length()];
        text.getChars(0, text.length(), content, 0);
        StringBuilder result = new StringBuilder();
        block10: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '\n': {
                    if (isEscapeSpace) {
                        result.append("<br/>");
                        continue block10;
                    }
                    result.append(content[i]);
                    continue block10;
                }
                case '\r': {
                    continue block10;
                }
                case '<': {
                    result.append("&lt;");
                    continue block10;
                }
                case '>': {
                    result.append("&gt;");
                    continue block10;
                }
                case '&': {
                    result.append("&amp;");
                    continue block10;
                }
                case '\'': {
                    result.append("&#039;");
                    continue block10;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block10;
                }
                case ' ': {
                    if (isEscapeSpace) {
                        result.append("&nbsp;");
                        continue block10;
                    }
                    result.append(content[i]);
                    continue block10;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String toText(String text) {
        if (text == null || "".equals(text)) {
            return "";
        }
        char[] content = new char[text.length()];
        text.getChars(0, text.length(), content, 0);
        StringBuilder result = new StringBuilder();
        block7: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '\n': {
                    continue block7;
                }
                case '\r': {
                    continue block7;
                }
                case '\t': {
                    continue block7;
                }
                case '\b': {
                    continue block7;
                }
                case '\f': {
                    continue block7;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String toHTMLAlt(String text) {
        if (text == null || "".equals(text)) {
            return "";
        }
        char[] content = new char[text.length()];
        text.getChars(0, text.length(), content, 0);
        StringBuilder result = new StringBuilder();
        block9: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '\r': {
                    continue block9;
                }
                case '<': {
                    result.append("&lt;");
                    continue block9;
                }
                case '>': {
                    result.append("&gt;");
                    continue block9;
                }
                case '&': {
                    result.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    result.append("&#039;");
                    continue block9;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block9;
                }
                case ' ': {
                    result.append("&nbsp;");
                    continue block9;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static <T> T escapeNULL(T str, T defaultValue) {
        return str == null ? defaultValue : str;
    }

    public static String formatFileSize(long fileSize, boolean isUseMinValue) {
        if (fileSize < 0L) {
            throw new ArithmeticException("fileSize less than zero");
        }
        String result = "";
        Locale locale = Locale.getDefault();
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(0);
        if (fileSize >= 0x40000000L) {
            float filesize = (float)fileSize / new Long(0x40000000L).floatValue();
            result = format.format(filesize) + " GB";
        } else if (fileSize >= 0x100000L) {
            float filesize = (float)fileSize / new Long(0x100000L).floatValue();
            result = format.format(filesize) + " MB";
        } else if (fileSize >= 1024L) {
            float filesize = (float)fileSize / new Long(1024L).floatValue();
            result = format.format(filesize) + " KB";
        } else {
            result = fileSize == 0L ? "0 KB" : (isUseMinValue ? "1 KB" : format.format(fileSize) + " B");
        }
        return result;
    }

    public static String join(Collection collection, String separator) {
        return StringUtils.join((Iterable)collection, (String)separator);
    }

    public static String join(String separator, String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String str : strings) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(str);
            ++i;
        }
        return sb.toString();
    }

    public static String joinDelNull(String separator, String ... strings) {
        StringBuilder sb = new StringBuilder();
        boolean hasValue = false;
        for (String str : strings) {
            boolean bl = hasValue = str != null && !"".equals(str);
            if (hasValue && sb.length() > 0) {
                sb.append(separator);
            }
            if (!hasValue) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    public static String[][] getSelectPeopleElements(String selectPeopleStr) {
        String[][] results = null;
        if (StringUtils.isNotBlank((CharSequence)selectPeopleStr)) {
            String[] entities = selectPeopleStr.split(",");
            results = new String[entities.length][2];
            int i = 0;
            for (String entity : entities) {
                String[] items = entity.split("[|]");
                results[i][0] = items[0];
                results[i][1] = items[1];
                ++i;
            }
        }
        return results;
    }

    public static String escapeJavascript(String str) {
        if (str == null) {
            return str;
        }
        StringBuilder out = new StringBuilder();
        int sz = str.length();
        block14: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.append("\\u00" + Strings.hex(ch));
                            break;
                        }
                        out.append("\\u000" + Strings.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    out.append('\\');
                    out.append('\'');
                    continue block14;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block14;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block14;
                }
                case '/': {
                    out.append("\\/");
                    continue block14;
                }
                case '!': {
                    out.append("\\!");
                    continue block14;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    public static String escapeQuot(String str) {
        if (str == null) {
            return str;
        }
        StringBuilder out = new StringBuilder();
        int sz = str.length();
        block14: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.append("\\u00" + Strings.hex(ch));
                            break;
                        }
                        out.append("\\u000" + Strings.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    out.append("&apos;");
                    continue block14;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block14;
                }
                case '<': {
                    out.append("&lt;");
                    continue block14;
                }
                case '>': {
                    out.append("&gt;");
                    continue block14;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block14;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isEmpty((CharSequence)str);
    }

    public static boolean isNotEmpty(String str) {
        return StringUtils.isNotEmpty((CharSequence)str);
    }

    public static boolean isBlank(String str) {
        return StringUtils.isBlank((CharSequence)str);
    }

    public static boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    public static boolean isNotEmpty(Collection c) {
        return !Strings.isEmpty(c);
    }

    public static boolean isNotBlank(String str) {
        return StringUtils.isNotBlank((CharSequence)str);
    }

    public static boolean isDigits(String str) {
        return Strings.isNotEmpty(str) && Pattern.matches(REGEX_DIGIT, str);
    }

    public static boolean isTrue(Boolean b) {
        return Boolean.TRUE.equals(b);
    }

    public static boolean isWord(String str) {
        return Strings.isNotEmpty(str) && Pattern.matches(REGEX_WORD, str);
    }

    public static boolean isI18NKey(String key) {
        if (Strings.isBlank(key)) {
            return false;
        }
        return Pattern.matches(REGEX_I18NKEY, key);
    }

    public static String getCanonicalPath(String filepath) {
        return Strings.getCanonicalPath(filepath, false);
    }

    public static String getCanonicalPathAndCreate(String filepath) {
        return Strings.getCanonicalPath(filepath, true);
    }

    private static String getCanonicalPath(String filepath, boolean isCreate) {
        if (Strings.isBlank(filepath)) {
            return null;
        }
        String path = FilenameUtils.normalize((String)filepath);
        File f = new File(path);
        try {
            File fc = f.getCanonicalFile();
            if (isCreate) {
                fc.mkdirs();
            }
            return fc.getAbsolutePath();
        }
        catch (IOException iOException) {
            return filepath;
        }
    }

    public static String getBaseHref(HttpServletRequest request) {
        return request.getScheme() + "://" + Strings.getServerName(request) + ":" + request.getServerPort();
    }

    public static String getServerName(HttpServletRequest request) {
        if (serverName != null) {
            return serverName;
        }
        try {
            return new URL(request.getRequestURL().toString()).getHost();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public static String getBaseContext(HttpServletRequest request) {
        return Strings.getBaseHref(request) + request.getContextPath();
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        String parameter = request.getParameter("clientPath");
        if (parameter != null) {
            return parameter;
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null) {
            String[] ips = ip.split(",");
            ip = null;
            for (String tmp : ips) {
                if ("unknown".equals(tmp)) continue;
                ip = tmp;
            }
            if (ip == null) {
                return null;
            }
            int endIndex = ip.indexOf("%");
            if (endIndex > 0) {
                ip = ip.substring(0, endIndex);
            }
        }
        return ip;
    }

    public static String toXmlStr(String srcStr) {
        String xml = srcStr;
        xml = xml.replaceAll("&", "&amp;");
        xml = xml.replaceAll("<", "&lt;");
        xml = xml.replaceAll(">", "&gt;");
        xml = xml.replaceAll("'", "&apos;");
        xml = xml.replaceAll("\"", "&quot;");
        return xml;
    }

    public static boolean isIncludeNotCharacter(String str) {
        if (str == null) {
            return false;
        }
        return Pattern.matches(REGEX_NOTCHARACTER, str);
    }

    public static boolean isDecimalExcludePlus(String str) {
        if (str == null) {
            return false;
        }
        return Pattern.matches(REGEX_DECIMAL_EXCLUDEPLUS, str);
    }

    public static <K, V> void addToMap1(Map<K, ArrayList<V>> map, K k, V v) {
        ArrayList<Object> list = map.get(k);
        if (list == null) {
            list = new ArrayList();
            map.put(k, list);
        }
        list.add(v);
    }

    public static <K, V> void addToMap(Map<K, List<V>> map, K k, V v) {
        List<V> list = map.get(k);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(k, list);
        }
        list.add(v);
    }

    public static String nobreakSpaceToSpace(String str) {
        if (str == null) {
            return null;
        }
        char nbsp = '\u00a0';
        return str.replace(nbsp, ' ');
    }

    public static <T> List<T>[] splitList(List<T> list, int num) {
        if (Strings.isEmpty(list)) {
            return new ArrayList[0];
        }
        if (num < 2) {
            throw new IllegalArgumentException("Argument num [" + num + "] must greater then 2");
        }
        int length = (int)Math.ceil((double)list.size() / (double)num);
        ArrayList[] result = new ArrayList[length];
        for (int i = 0; i < length; ++i) {
            int first = i * num;
            int max = Math.min(list.size(), first + num);
            List<T> temp = list.subList(first, max);
            result[i] = new ArrayList<T>(temp);
        }
        return result;
    }

    public static String escapeJson(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuilder tempBuffer = new StringBuilder(str.length() * 6);
        for (int i = 0; i < str.length(); ++i) {
            char tempChar = str.charAt(i);
            if (ILLEGAL_CHARACTER_SET.indexOf(tempChar) > -1) {
                tempBuffer.append(UNICODE_SEPERATER + Strings.formatHexString(Integer.toHexString(str.codePointAt(i))));
                continue;
            }
            tempBuffer.append(tempChar);
        }
        return tempBuffer.toString();
    }

    private static String formatHexString(String str) {
        String result = str == null ? "" : str;
        result = UNICODE_FORMAT_ARRAY[4 - result.length()] + result;
        return result;
    }

    public static <T> List<T> newArrayList(T ... ts) {
        if (ts == null || ts.length == 0) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>(ts.length);
        for (T t : ts) {
            list.add(t);
        }
        return list;
    }

    public static <T> Set<T> newHashSet(T ... ts) {
        HashSet<T> list = new HashSet<T>();
        if (ts != null && ts.length > 0) {
            for (T t : ts) {
                list.add(t);
            }
        }
        return list;
    }

    public static <T> boolean equals(T obj1, T obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return false;
    }

    public static boolean in(String src, String ... terms) {
        for (String s : terms) {
            if (!src.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(String src, String ... terms) {
        for (String s : terms) {
            if (!src.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static String escapeUnsupportAscii(String value) {
        if (Strings.isEmpty(value)) {
            return value;
        }
        char[] chars = value.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] < '\b' || chars[i] == '\u000b' || chars[i] >= '\u000e' && chars[i] <= '\u001f') continue;
            chars[pos++] = chars[i];
        }
        return new String(chars, 0, pos);
    }

    public static <T> List<T> getCollectionActionResult(Collection<T> oldList, Collection<T> newList, CollectionActionType actionType2) {
        List result = null;
        boolean oldIsEmpty = CollectionUtils.isEmpty(oldList);
        boolean newIsEmpty = CollectionUtils.isEmpty(newList);
        switch (actionType2) {
            case getAdded: {
                if (oldIsEmpty || newIsEmpty) {
                    result = Strings.parseCollection2ListIgnoreEmpty(newList);
                    break;
                }
                List common = (List)CollectionUtils.intersection(oldList, newList);
                result = (List)CollectionUtils.subtract(newList, (Iterable)common);
                break;
            }
            case getReduced: {
                if (oldIsEmpty || newIsEmpty) {
                    result = Strings.parseCollection2ListIgnoreEmpty(oldList);
                    break;
                }
                List common = (List)CollectionUtils.intersection(oldList, newList);
                result = (List)CollectionUtils.subtract(oldList, (Iterable)common);
                break;
            }
            case union: {
                if (!oldIsEmpty && !newIsEmpty) {
                    result = (List)CollectionUtils.union(oldList, newList);
                    break;
                }
                if (oldIsEmpty) {
                    result = Strings.parseCollection2ListIgnoreEmpty(newList);
                    break;
                }
                result = Strings.parseCollection2ListIgnoreEmpty(oldList);
                break;
            }
            case intersection: {
                if (oldIsEmpty || newIsEmpty) break;
                result = (List)CollectionUtils.intersection(oldList, newList);
                break;
            }
            case disjunction: {
                if (!oldIsEmpty && !newIsEmpty) {
                    result = (List)CollectionUtils.disjunction(oldList, newList);
                    break;
                }
                if (oldIsEmpty) {
                    result = Strings.parseCollection2ListIgnoreEmpty(newList);
                    break;
                }
                result = Strings.parseCollection2ListIgnoreEmpty(oldList);
                break;
            }
            case subtract: {
                if (!oldIsEmpty && !newIsEmpty) {
                    result = (List)CollectionUtils.subtract(oldList, newList);
                    break;
                }
                if (!newIsEmpty) break;
                result = Strings.parseCollection2ListIgnoreEmpty(oldList);
            }
        }
        return result;
    }

    public static <T> List<T> getSumCollection(Collection<T> a, Collection<T> b) {
        return Strings.getCollectionActionResult(a, b, CollectionActionType.union);
    }

    public static <T> List<T> getIntersection(Collection<T> a, Collection<T> b) {
        return Strings.getCollectionActionResult(a, b, CollectionActionType.intersection);
    }

    public static <T> List<T> getAddedCollection(Collection<T> oldColl, Collection<T> newColl) {
        return Strings.getCollectionActionResult(oldColl, newColl, CollectionActionType.getAdded);
    }

    public static <T> List<T> getReducedCollection(Collection<T> oldColl, Collection<T> newColl) {
        return Strings.getCollectionActionResult(oldColl, newColl, CollectionActionType.getReduced);
    }

    public static <T> List<T> parseCollection2ListIgnoreEmpty(Collection<T> c) {
        if (CollectionUtils.isNotEmpty(c)) {
            return new ArrayList<T>(c);
        }
        return null;
    }

    public static <T> void addAllIgnoreEmpty(Collection<T> mainCollection, Collection<T> toBeAdded) {
        if (CollectionUtils.isNotEmpty(toBeAdded) && mainCollection != null) {
            mainCollection.addAll(toBeAdded);
        }
    }

    public static <T> void removeAllIgnoreEmpty(Collection<T> mainCollection, Collection<T> toBeRemoved) {
        if (CollectionUtils.isNotEmpty(mainCollection) && CollectionUtils.isNotEmpty(toBeRemoved)) {
            mainCollection.removeAll(toBeRemoved);
        }
    }

    public static <T> int getSizeIgnoreEmpty(Collection<T> c) {
        return CollectionUtils.isEmpty(c) ? 0 : c.size();
    }

    public static String trimXSSHtml(String html) {
        if (html == null) {
            return null;
        }
        html = p1.matcher(html).replaceAll("<s$1");
        return p2.matcher(html).replaceAll("$1s$2$3");
    }

    public static String removeEmoji(String source) {
        User user;
        if (source == null) {
            return null;
        }
        String dbms = JDBCAgent.getDBType();
        boolean requireRemoveEmoji = "MySQL".equalsIgnoreCase(dbms);
        if (requireRemoveEmoji && (user = AppContext.getCurrentUser()) != null && user.isFromM1()) {
            return EmojiParser.removeAllEmojis((String)source);
        }
        return source;
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace((String)text, (String)searchString, (String)replacement);
    }

    public static String replaceNbspLO(String s) {
        StringBuilder news = new StringBuilder();
        boolean isPNbsp = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            boolean isNbsp = ch == ' ';
            boolean hasAppendNbsp = false;
            if (isNbsp) {
                if (isPNbsp) {
                    news.append("&nbsp;");
                    hasAppendNbsp = true;
                }
                isPNbsp = true;
            } else {
                isPNbsp = false;
            }
            if (hasAppendNbsp) continue;
            news.append(ch);
        }
        return news.toString();
    }

    public static String escapeFullWidth(String s) {
        if (s == null || "".equals(s)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block11: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    continue block11;
                }
                case '<': {
                    sb.append('\uff1c');
                    continue block11;
                }
                case '\'': {
                    sb.append('\\');
                    sb.append('\'');
                    sb.append('\\');
                    sb.append('\'');
                    continue block11;
                }
                case '\"': {
                    sb.append('\\');
                    sb.append('\"');
                    continue block11;
                }
                case '&': {
                    sb.append('\uff06');
                    continue block11;
                }
                case '\\': {
                    sb.append('\uff3c');
                    continue block11;
                }
                case '#': {
                    sb.append('\uff03');
                    continue block11;
                }
                case ':': {
                    sb.append('\uff1a');
                    continue block11;
                }
                case '%': {
                    sb.append("\\\\%");
                    continue block11;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String getLocalIPv6Address() throws IOException {
        InetAddress inetAddress = null;
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        block0: while (networkInterfaces.hasMoreElements()) {
            Enumeration<InetAddress> inetAds = networkInterfaces.nextElement().getInetAddresses();
            while (inetAds.hasMoreElements()) {
                inetAddress = inetAds.nextElement();
                if (!(inetAddress instanceof Inet6Address) || Strings.isReservedAddr(inetAddress)) continue;
                break block0;
            }
        }
        if (inetAddress == null) {
            return null;
        }
        String ipAddr = inetAddress.getHostAddress();
        int index = ipAddr.indexOf(37);
        if (index > 0) {
            ipAddr = ipAddr.substring(0, index);
        }
        return ipAddr;
    }

    private static boolean isReservedAddr(InetAddress inetAddr) {
        return inetAddr.isAnyLocalAddress() || inetAddr.isLinkLocalAddress() || inetAddr.isLoopbackAddress();
    }

    public static boolean isIPv6LiteralAddress(String ip) {
        return IPAddressUtil.isIPv6LiteralAddress(ip);
    }

    public static boolean isIPv4LiteralAddress(String ip) {
        return IPAddressUtil.isIPv4LiteralAddress(ip);
    }

    public static boolean isIPV6Format(String ip) {
        ip = ip.trim();
        Pattern pattern = Pattern.compile("^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:)|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}(:[0-9A-Fa-f]{1,4}){1,2})|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){1,3})|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){1,4})|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){1,5})|([0-9A-Fa-f]{1,4}:(:[0-9A-Fa-f]{1,4}){1,6})|(:(:[0-9A-Fa-f]{1,4}){1,7})|(([0-9A-Fa-f]{1,4}:){6}(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3})|(([0-9A-Fa-f]{1,4}:){5}:(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3})|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}:(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3})|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}:(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3})|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}:(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3})|([0-9A-Fa-f]{1,4}:(:[0-9A-Fa-f]{1,4}){0,4}:(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3})|(:(:[0-9A-Fa-f]{1,4}){0,5}:(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}))$");
        return pattern.matcher(ip).matches();
    }

    public static boolean isIPV4Format(String ip) {
        ip = ip.trim();
        Pattern pattern = Pattern.compile("^(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}$");
        return pattern.matcher(ip).matches();
    }

    public static String upperCase(String str) {
        return StringUtils.upperCase((String)str);
    }

    public static String lowerCase(String str) {
        return StringUtils.lowerCase((String)str);
    }

    public static String capitalize(String str) {
        return StringUtils.capitalize((String)str);
    }

    public static String uncapitalize(String str) {
        return StringUtils.uncapitalize((String)str);
    }

    public static boolean isLong(String id) {
        if (Strings.isBlank(id)) {
            return false;
        }
        String regex = "^-?[1-9]{1}[\\d]{0,18}$";
        return id.matches(regex);
    }

    public static boolean hasSameString(Collection<String> c1, Collection<String> c2) {
        if (Strings.isNotEmpty(c1) && Strings.isNotEmpty(c2)) {
            for (String c : c1) {
                if (!c2.contains(c)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum CollectionActionType {
        getAdded,
        getReduced,
        union,
        intersection,
        disjunction,
        subtract;

    }
}

