/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;

public class ReqUtil {
    private static final Log logger = CtpLogFactory.getLog(ReqUtil.class);

    public static String getString(HttpServletRequest request, String name) {
        return ReqUtil.getString(request, name, null);
    }

    public static int getInt(HttpServletRequest request, String name) {
        return ReqUtil.getInt(request, name, 0);
    }

    public static long getLong(HttpServletRequest request, String name) {
        return ReqUtil.getLong(request, name, 0L);
    }

    public static boolean getBoolean(HttpServletRequest request, String name) {
        return ReqUtil.getBoolean(request, name, false);
    }

    public static int getInt(HttpServletRequest request, String name, int defaultValue) {
        int i = defaultValue;
        String str = ReqUtil.getString(request, name, String.valueOf(defaultValue));
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
        }
        return i;
    }

    public static long getLong(HttpServletRequest request, String name, long defaultValue) {
        long i = defaultValue;
        String str = ReqUtil.getString(request, name, String.valueOf(defaultValue));
        try {
            i = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
        }
        return i;
    }

    public static boolean getBoolean(HttpServletRequest request, String name, boolean defaultValue) {
        boolean i = defaultValue;
        String str = ReqUtil.getString(request, name, String.valueOf(defaultValue));
        try {
            i = Boolean.parseBoolean(str);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
        }
        return i;
    }

    public static String getString(HttpServletRequest request, String name, String defaultValue) {
        String str = defaultValue;
        String paramValue = request.getParameter(name);
        if (paramValue != null) {
            str = paramValue;
        }
        return str;
    }

    public static String[] getArray(HttpServletRequest request, String name) {
        String[] str = request.getParameterValues(name);
        return str;
    }

    public static int[] getIntArray(HttpServletRequest request, String name) {
        String[] strArray = request.getParameterValues(name);
        int[] result = new int[]{};
        if (strArray != null && strArray.length > 0) {
            result = new int[strArray.length];
            int i = 0;
            for (String s : strArray) {
                try {
                    result[i] = Integer.parseInt(s);
                    ++i;
                }
                catch (NumberFormatException e) {
                    logger.error((Object)e);
                }
            }
        }
        return result;
    }

    public static long[] getLongArray(HttpServletRequest request, String name) {
        String[] strArray = request.getParameterValues(name);
        long[] result = new long[]{};
        if (strArray != null && strArray.length > 0) {
            result = new long[strArray.length];
            int i = 0;
            for (String s : strArray) {
                try {
                    result[i] = Long.parseLong(s);
                    ++i;
                }
                catch (NumberFormatException e) {
                    logger.error((Object)e);
                }
            }
        }
        return result;
    }
}

