/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.InfrastructureException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.ClassUtil;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;

public class ParamUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(ParamUtil.class);
    public static final String webSession = "webSessionFlag__";
    private static final Pattern arrayRegex = Pattern.compile("\\s*(\\w*)\\s*\\[\\s*([\\w=<>]*)\\s*\\]");

    private static String objectToString(Object valueObj) {
        if (valueObj instanceof String[]) {
            String[] array = (String[])valueObj;
            if (array.length == 0) {
                return "";
            }
            return array[0];
        }
        return valueObj.toString();
    }

    public static Map getJsonParams() {
        Object dataObj = ParamUtil.jsonObj(null);
        if (dataObj == null) {
            LOGGER.debug((Object)"No json data commited!");
            return new HashMap();
        }
        if (dataObj instanceof Map) {
            Map mp = (Map)dataObj;
            for (Object next : mp.values()) {
                if (!(next instanceof String) && !(next instanceof Number)) continue;
                return mp;
            }
            LOGGER.debug((Object)"No json params data commited,it's a domain param!");
            return new HashMap();
        }
        LOGGER.debug((Object)"No json params data commited!");
        return new HashMap();
    }

    public static List getJsonParamsGroup() {
        Object dataObj = ParamUtil.jsonObj(null);
        if (dataObj == null) {
            LOGGER.debug((Object)"No json data commited!");
            return new ArrayList();
        }
        if (dataObj instanceof List) {
            List dataList = (List)dataObj;
            for (int i = 0; i < dataList.size(); ++i) {
                if (!(dataList.get(i) instanceof Map)) continue;
                return dataList;
            }
            LOGGER.debug((Object)"No json params group data commited,it's a unknown data format!");
            return new ArrayList();
        }
        LOGGER.debug((Object)"No json group data commited!");
        return new ArrayList();
    }

    public static Map getJsonDomain(String domainId) {
        Object dataObj = ParamUtil.jsonObj(null);
        if (dataObj == null) {
            LOGGER.debug((Object)"No json data commited!");
            return new HashMap();
        }
        if (dataObj instanceof Map) {
            Map dataMap = (Map)dataObj;
            Object domainObj = dataMap.get(domainId);
            if (domainObj == null) {
                LOGGER.debug((Object)("No json domain data commited by domainId:" + domainId));
                return new HashMap();
            }
            if (domainObj instanceof Map) {
                return (Map)domainObj;
            }
            LOGGER.debug((Object)("No json domain data commited by domainId:" + domainId + ", it's a group domain, use getJsonDomainGroup() instead."));
            return new HashMap();
        }
        LOGGER.debug((Object)("No json domain data commited by domainId:" + domainId));
        return new HashMap();
    }

    public static List getJsonDomainGroup(String domainId) {
        Object dataObj = ParamUtil.jsonObj(null);
        if (dataObj == null) {
            LOGGER.debug((Object)"No json data commited!");
            return new ArrayList();
        }
        if (dataObj instanceof Map) {
            Map dataMap = (Map)dataObj;
            Object domainObj = dataMap.get(domainId);
            if (domainObj == null) {
                LOGGER.debug((Object)("No json domain data commited by domainId:" + domainId));
                return new ArrayList();
            }
            if (domainObj instanceof List) {
                List domainList = (List)domainObj;
                for (int i = 0; i < domainList.size(); ++i) {
                    if (!(domainList.get(i) instanceof Map)) continue;
                    return domainList;
                }
                LOGGER.debug((Object)"No json domain group data commited,it's a unknown data format!");
                return new ArrayList();
            }
            LOGGER.debug((Object)("No json domain data commited by domainId:" + domainId + ", it's not a domain group, use getJsonDomain() instead."));
            return new ArrayList();
        }
        LOGGER.debug((Object)("No json domain data commited by domainId:" + domainId));
        return new ArrayList();
    }

    public static Map currentJsonDomainMap() {
        Object dataObj = ParamUtil.jsonObj(null);
        if (dataObj == null) {
            LOGGER.debug((Object)"No json data commited!");
            return new HashMap();
        }
        if (dataObj instanceof Map) {
            Map dataMap = (Map)dataObj;
            return dataMap;
        }
        LOGGER.debug((Object)"No json domain data commited!");
        return new HashMap();
    }

    public static Object getJsonParamsToBean(Object bean) {
        return ParamUtil.mapToBean(ParamUtil.getJsonParams(), bean, true);
    }

    public static Object getJsonParamsToBean(Object bean, boolean processNull) {
        return ParamUtil.mapToBean(ParamUtil.getJsonParams(), bean, processNull);
    }

    public static List getJsonParamsGroupToBeanList(Class beanCls) {
        ArrayList resultList = new ArrayList();
        try {
            List paramsGroup = ParamUtil.getJsonParamsGroup();
            for (int i = 0; i < paramsGroup.size(); ++i) {
                Object bean = beanCls.newInstance();
                resultList.add(bean);
                ParamUtil.mapToBean((Map)paramsGroup.get(i), bean, true);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        return resultList;
    }

    public static List getJsonParamsGroupToBeanList(Class beanCls, boolean processNull) {
        ArrayList resultList = new ArrayList();
        try {
            List paramsGroup = ParamUtil.getJsonParamsGroup();
            for (int i = 0; i < paramsGroup.size(); ++i) {
                Object bean = beanCls.newInstance();
                resultList.add(bean);
                ParamUtil.mapToBean((Map)paramsGroup.get(i), bean, processNull);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        return resultList;
    }

    public static Object getJsonDomainToBean(String domainId, Object bean) {
        return ParamUtil.mapToBean(ParamUtil.getJsonDomain(domainId), bean, true);
    }

    public static Object getJsonDomainToBean(String domainId, Object bean, boolean processNull) {
        return ParamUtil.mapToBean(ParamUtil.getJsonDomain(domainId), bean, processNull);
    }

    public static List getJsonDomainGroupToBeanList(String domainId, Class beanCls) {
        ArrayList resultList = new ArrayList();
        try {
            List paramsGroup = ParamUtil.getJsonDomainGroup(domainId);
            for (int i = 0; i < paramsGroup.size(); ++i) {
                Object bean = beanCls.newInstance();
                resultList.add(bean);
                ParamUtil.mapToBean((Map)paramsGroup.get(i), bean, true);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        return resultList;
    }

    public static List getJsonDomainGroupToBeanList(String domainId, Class beanCls, boolean processNull) {
        ArrayList resultList = new ArrayList();
        try {
            List paramsGroup = ParamUtil.getJsonDomainGroup(domainId);
            for (int i = 0; i < paramsGroup.size(); ++i) {
                Object bean = beanCls.newInstance();
                resultList.add(bean);
                ParamUtil.mapToBean((Map)paramsGroup.get(i), bean, processNull);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
        return resultList;
    }

    public static <T> T getRawJsonToBean(Class<T> clz) {
        return (T)ParamUtil.jsonObj(clz);
    }

    private static Object jsonObj(Class cls) {
        Object jsonObj = AppContext.getThreadContext("THREAD_CONTEXT_JSONOBJ_KEY");
        if (jsonObj == null || cls != null) {
            String jsonString = (String)AppContext.getThreadContext("THREAD_CONTEXT_JSONSTR_KEY");
            jsonObj = JSONUtil.parseJSONString(Strings.removeEmoji(jsonString), cls);
            AppContext.putThreadContext("THREAD_CONTEXT_JSONOBJ_KEY", jsonObj);
        }
        return jsonObj;
    }

    public static Map beanToMap(Object beanObj, Map map, boolean processNull) {
        return ParamUtil.beanToMap(beanObj, map, processNull, "yyyy-MM-dd", -1);
    }

    public static Map beanToMap(Object beanObj, Map map, boolean processNull, String datePattern) {
        return ParamUtil.beanToMap(beanObj, map, processNull, datePattern, -1);
    }

    public static Map beanToMap(Object beanObj, Map map, boolean processNull, int scale) {
        return ParamUtil.beanToMap(beanObj, map, processNull, "yyyy-MM-dd", scale);
    }

    public static Map beanToMap(Object beanObj, Map map, boolean processNull, String datePattern, int scale) {
        return ParamUtil.beanToMap(beanObj, map, processNull, datePattern, scale, false);
    }

    public static Map beanToMap(Object beanObj, Map map, boolean processNull, String datePattern, int scale, boolean forceUpperCase) {
        Map result = map;
        for (Class<?> lClass = beanObj.getClass(); lClass != Object.class; lClass = lClass.getSuperclass()) {
            Method[] methods = lClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method == null || method.getModifiers() != 1) continue;
                ParamUtil.fillFieldToMap(method, beanObj, processNull, datePattern, scale, result, forceUpperCase);
            }
        }
        return result;
    }

    private static void fillFieldToMap(Method m, Object obj, boolean processNull, String datePattern, int scale, Map result, boolean forceUpperCase) {
        String methodName = m.getName();
        try {
            boolean isGet = methodName.startsWith("get");
            if ((isGet || methodName.startsWith("is")) && m.getParameterTypes().length == 0) {
                String key;
                if (isGet) {
                    key = String.valueOf(Character.toLowerCase(methodName.charAt(3)));
                    if (methodName.length() > 4) {
                        key = key + methodName.substring(4);
                    }
                } else {
                    key = String.valueOf(Character.toLowerCase(methodName.charAt(2)));
                    if (methodName.length() > 3) {
                        key = key + methodName.substring(3);
                    }
                }
                Object valueObj = m.invoke(obj, new Object[0]);
                if ("getCompositeId".equals(methodName)) {
                    if (valueObj != null) {
                        Method[] pkMethods = valueObj.getClass().getDeclaredMethods();
                        for (int j = 0; j < pkMethods.length; ++j) {
                            Method pkMethod = pkMethods[j];
                            if (pkMethod.getModifiers() != 1) continue;
                            ParamUtil.fillFieldToMap(pkMethod, valueObj, processNull, datePattern, scale, result, forceUpperCase);
                        }
                    }
                } else if (valueObj != null) {
                    String value = null;
                    if (valueObj instanceof Date) {
                        value = DateUtil.format((Date)valueObj, datePattern);
                    } else if (valueObj instanceof BigDecimal && scale > 0) {
                        BigDecimal bd = (BigDecimal)valueObj;
                        bd = bd.setScale(scale, 4);
                        value = bd.toString();
                    } else {
                        value = valueObj.toString();
                    }
                    if (processNull || value != null) {
                        result.put(forceUpperCase ? key.toUpperCase() : key, value);
                    }
                } else if (processNull) {
                    result.put(forceUpperCase ? key.toUpperCase() : key, null);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
    }

    public static <T> List<T> mapsToBeans(List<Map<String, Object>> data, Class<T> type, boolean processNull) {
        return ParamUtil.mapsToBeans(data, type, processNull, true);
    }

    public static <T> List<T> mapsToBeans(List<Map<String, Object>> data, Class<T> type, boolean processNull, boolean findOther) {
        ArrayList<Object> rt = new ArrayList<Object>();
        for (Map<String, Object> item : data) {
            rt.add(ParamUtil.mapToBean(item, type, processNull, findOther));
        }
        return rt;
    }

    public static Object requestToBean(HttpServletRequest request, Object bean, boolean processNull) {
        Map<String, Object> tmpdatas = ParamUtil.getParameterMapFromRequest(request, Object.class);
        for (Map.Entry<String, Object> item : tmpdatas.entrySet()) {
            Object tdata = item.getValue();
            if (tdata == null || tdata instanceof Map) continue;
            item.setValue(ParamUtil.objectToString(tdata));
        }
        return ParamUtil.mapToBean(tmpdatas, bean.getClass(), processNull);
    }

    public static Object mapToBean(Map<String, Object> data, Object bean, boolean processNull) {
        return ParamUtil.mapToBean(data, bean, processNull, true);
    }

    public static Object mapToBean(Map<String, Object> data, Object bean, boolean processNull, boolean findOther) {
        try {
            Method[] methods;
            Class<?> type;
            Object rt = bean;
            if (bean instanceof Class) {
                type = (Class<?>)bean;
                rt = type.newInstance();
            } else {
                type = rt.getClass();
            }
            for (Method method : methods = type.getMethods()) {
                String methodName = method.getName();
                if (!"set".equals(methodName.substring(0, 3))) continue;
                String name = ClassUtil.getBeanPro(methodName, "set", false);
                Class<?>[] types = method.getParameterTypes();
                boolean checkField = false;
                Object value = null;
                if (!data.containsKey(name)) {
                    if (!data.containsKey(name.toUpperCase()) && findOther) {
                        for (String key : data.keySet()) {
                            if (!key.equalsIgnoreCase(name)) continue;
                            value = data.get(key);
                            checkField = true;
                            break;
                        }
                    } else {
                        value = data.get(name.toUpperCase());
                        checkField = true;
                    }
                } else {
                    value = data.get(name);
                    checkField = true;
                }
                if (value == null && !processNull || types.length != 1) continue;
                Class<?> type0 = types[0];
                if (value == null && (type0 == Boolean.TYPE || type0 == Character.TYPE || type0 == Float.TYPE || type0 == Double.TYPE || type0 == Byte.TYPE || type0 == Short.TYPE || type0 == Integer.TYPE || type0 == Long.TYPE)) continue;
                method.invoke(rt, ClassUtil.CASE(value, types[0]));
            }
            return rt;
        }
        catch (IllegalAccessException e) {
            throw new InfrastructureException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InfrastructureException(e);
        }
        catch (InvocationTargetException e) {
            throw new InfrastructureException(e);
        }
        catch (InstantiationException e) {
            throw new InfrastructureException(e);
        }
    }

    public static String getString(Map m, String name, String defaultValue, boolean b) {
        String str = defaultValue;
        Object val = m.get(name);
        if (val != null) {
            if (val.getClass().isArray()) {
                Object[] objs = (Object[])val;
                if (objs.length > 0) {
                    str = objs[0].toString();
                }
            } else {
                str = val.toString();
            }
        } else if (b) {
            throw new InfrastructureException(name + "\u53c2\u6570\u4e3a\u7a7aNULL");
        }
        return str;
    }

    public static Integer getInt(Map m, String name, Integer defaultValue, boolean b) {
        Integer i = defaultValue;
        String str = ParamUtil.getString(m, name, String.valueOf(defaultValue), b);
        if (!b && (Strings.isBlank(str) || "null".equals(str))) {
            return defaultValue;
        }
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            throw new InfrastructureException(name + "\u53c2\u6570\u503c'" + str + "'\u8f6c\u6362Integer\u5f02\u5e38", nfe);
        }
        return i;
    }

    public static Long getLong(Map m, String name, Long defaultValue, boolean b) {
        Long l = defaultValue;
        String str = ParamUtil.getString(m, name, defaultValue == null ? null : String.valueOf(defaultValue), b);
        if (!b && Strings.isBlank(str)) {
            return defaultValue;
        }
        try {
            l = Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            throw new InfrastructureException(name + "\u53c2\u6570\u503c'" + str + "'\u8f6c\u6362Long\u5f02\u5e38", nfe);
        }
        return l;
    }

    public static Double getDouble(Map m, String name, Double defaultValue, boolean b) {
        Double d = defaultValue;
        String str = ParamUtil.getString(m, name, String.valueOf(defaultValue), b);
        if (!b && str == null) {
            return defaultValue;
        }
        try {
            d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            throw new InfrastructureException(name + "\u53c2\u6570\u503c'" + str + "'\u8f6c\u6362Double\u5f02\u5e38", nfe);
        }
        return d;
    }

    public static Date getDate(Map m, String name, Date defaultValue, String pattern, boolean b) {
        Date d = defaultValue;
        String str = ParamUtil.getString(m, name, null, b);
        if (!b && str == null) {
            return defaultValue;
        }
        try {
            d = DateUtil.parse(str, pattern);
        }
        catch (ParseException nfe) {
            throw new InfrastructureException(name + "\u53c2\u6570\u503c'" + str + "'\u8f6c\u6362Date\u5f02\u5e38", nfe);
        }
        return d;
    }

    public static Date getDate(Map m, String name, boolean b) {
        return ParamUtil.getDate(m, name, null, "yyyy-MM-dd", b);
    }

    public static Date getDate(Map m, String name) {
        return ParamUtil.getDate(m, name, false);
    }

    public static Long getLong(Map m, String name) {
        return ParamUtil.getLong(m, name, null, false);
    }

    public static Long getLong(Map m, String name, Long defaultValue) {
        return ParamUtil.getLong(m, name, defaultValue, false);
    }

    public static String getString(Map m, String name) {
        return ParamUtil.getString(m, name, null, false);
    }

    public static String getString(Map m, String name, String defaultValue) {
        return ParamUtil.getString(m, name, defaultValue, false);
    }

    public static String getString(Map m, String name, boolean b) {
        return ParamUtil.getString(m, name, null, b);
    }

    public static Integer getInt(Map m, String name) {
        return ParamUtil.getInt(m, name, null, false);
    }

    public static Integer getInt(Map m, String name, int defaultValue) {
        return ParamUtil.getInt(m, name, defaultValue, false);
    }

    public static Integer getInt(Map m, String name, boolean b) {
        return ParamUtil.getInt(m, name, null, b);
    }

    public static <T> Map<String, T> getParameterMapFromRequest(HttpServletRequest request, Class<T> valueType) {
        HashMap rtMap = new HashMap();
        Map reqMap = request.getParameterMap();
        Set set = reqMap.entrySet();
        for (Map.Entry entry : set) {
            for (String str : (String[])entry.getValue()) {
                rtMap.put(entry.getKey(), str);
            }
        }
        return rtMap;
    }
}

