/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.JDBCAgent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class POUtil {
    private static boolean decamelCase = true;
    private static final Set<String> EXCLUDE_METHOD_LIST = new HashSet<String>();

    public static void importFromFile(File f) throws BusinessException {
        try {
            POUtil.importFromStream(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new BusinessException(e);
        }
    }

    public static void importFromStream(InputStream is) throws BusinessException {
        if (is == null) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u8f93\u5165\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JDBCAgent dba = new JDBCAgent();
        try {
            ObjectInputStream in = new ObjectInputStream(is);
            String sql = (String)in.readObject();
            dba.batch1Prepare(sql);
            List recordList = (List)in.readObject();
            for (List record : recordList) {
                dba.batch2Add(record);
            }
            in.close();
            dba.batch3Execute();
        }
        catch (Exception ioe) {
            throw new BusinessException(ioe);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            dba.close();
        }
    }

    public static byte[] exportToStream(List<?> poList) throws BusinessException {
        String sql = null;
        ArrayList recordList = new ArrayList();
        ArrayList<String> columnList = new ArrayList<String>();
        for (Object po : poList) {
            Map<String, Object> map = POUtil.toMap(po);
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (decamelCase) {
                    key = POUtil.decamelCase(key);
                }
                if (sql == null) {
                    columnList.add(key);
                }
                valueList.add(value);
            }
            recordList.add(valueList);
            if (sql != null) continue;
            String table = po.getClass().getSimpleName();
            if (decamelCase) {
                table = POUtil.decamelCase(table);
            }
            String columns = StringUtils.join(columnList, (String)",");
            ArrayList<String> valueStringList = new ArrayList<String>(columnList.size());
            for (int i = 0; i < columnList.size(); ++i) {
                valueStringList.add("?");
            }
            String values = StringUtils.join(valueStringList, (String)",");
            sql = MessageFormat.format("insert into {0}({1}) values({2})", table, columns, values);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(sql);
            out.writeObject(recordList);
            out.close();
        }
        catch (IOException ioe) {
            throw new BusinessException(ioe);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static String toInsertSQL(Object po) throws BusinessException {
        void var5_9;
        Map<String, Object> map = POUtil.toMap(po);
        ArrayList<String> columnList = new ArrayList<String>();
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (decamelCase) {
                key = POUtil.decamelCase(key);
            }
            columnList.add(key);
            valueList.add(value);
        }
        ArrayList<String> valueStringList = new ArrayList<String>();
        for (Object o : valueList) {
            if (o == null) {
                valueStringList.add("null");
                continue;
            }
            if (o instanceof Date) {
                valueStringList.add("'" + Datetimes.formatDate((Date)o) + "'");
                continue;
            }
            valueStringList.add("'" + o + "'");
        }
        String string = po.getClass().getSimpleName();
        if (decamelCase) {
            String string2 = POUtil.decamelCase(string);
        }
        String columns = StringUtils.join(columnList, (String)",");
        String values = StringUtils.join(valueStringList, (String)",");
        return MessageFormat.format("insert into {0}({1}) values({2})", var5_9, columns, values);
    }

    private static Map<String, Object> toMap(Object po) throws BusinessException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        try {
            BeanInfo info = Introspector.getBeanInfo(po.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                Method getter = pd.getReadMethod();
                if (getter == null) continue;
                Class<Object> returnType = getter.getReturnType();
                String name = pd.getName();
                String methodName = getter.getName();
                if (EXCLUDE_METHOD_LIST.contains(methodName)) continue;
                if (methodName.startsWith("is") || methodName.startsWith("has")) {
                    name = methodName;
                }
                if ("class".equals(name) || returnType.isAssignableFrom(Collection.class) || returnType.isAssignableFrom(Map.class)) continue;
                Object value = getter.invoke(po, new Object[0]);
                values.put(name, value);
            }
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
        return values;
    }

    private static String decamelCase(String camelCaseString) {
        return StringUtils.join((Object[])POUtil.splitByCharacterTypeCamelCase(camelCaseString), (String)"_").toLowerCase();
    }

    private static String[] splitByCharacterTypeCamelCase(String str) {
        return POUtil.splitByCharacterType(str, true);
    }

    private static String[] splitByCharacterType(String str, boolean camelCase) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return new String[0];
        }
        char[] c = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        for (int pos = tokenStart + 1; pos < c.length; ++pos) {
            int type = Character.getType(c[pos]);
            if (type == currentType || type == 9) continue;
            if (camelCase && (type == 2 || type == 9) && currentType == 1) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    list.add(new String(c, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list.add(new String(c, tokenStart, pos - tokenStart));
                tokenStart = pos;
            }
            currentType = type;
        }
        list.add(new String(c, tokenStart, c.length - tokenStart));
        return list.toArray(new String[list.size()]);
    }

    static {
        EXCLUDE_METHOD_LIST.add("isNew");
    }
}

