/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class ObjectUtil {
    private static final Log log = CtpLogFactory.getLog(ObjectUtil.class);

    public static Object getPropertyObject(Class mainCls, String property, String value) {
        try {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            Class<?> cls = null;
            try {
                PropertyDescriptor p = PropertyUtils.getPropertyDescriptor(mainCls.newInstance(), (String)property);
                cls = p.getPropertyType();
            }
            catch (IllegalAccessException e) {
                log.error((Object)"\u5b9e\u4f53\u7684Value\u8f6c\u7c7b\u578b\u51fa\u9519\uff1a", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"\u5b9e\u4f53\u7684Value\u8f6c\u7c7b\u578b\u51fa\u9519\uff1a", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)"\u5b9e\u4f53\u7684Value\u8f6c\u7c7b\u578b\u51fa\u9519\uff1a", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)"\u5b9e\u4f53\u7684Value\u8f6c\u7c7b\u578b\u51fa\u9519\uff1a", (Throwable)e);
            }
            if (cls == null) {
                return null;
            }
            String clsName = cls.getSimpleName();
            Object newValue = value;
            if ("String".equals(clsName)) {
                newValue = value;
            } else if ("Integer".equals(clsName)) {
                newValue = Integer.valueOf(value);
            } else if ("Long".equals(clsName)) {
                newValue = Long.valueOf(value);
            } else if ("Boolean".equalsIgnoreCase(clsName)) {
                newValue = "1".equals(value) || "true".equals(value) || "t".equals(value) ? Boolean.TRUE : Boolean.FALSE;
            }
            return newValue;
        }
        catch (SecurityException e) {
            log.error((Object)"\u5b9e\u4f53\u7684Value\u8f6c\u7c7b\u578b\u51fa\u9519\uff1a", (Throwable)e);
            return value;
        }
    }
}

