/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.hibernate.Query;

public class ListSearchHelper {
    public static final String defaultExpressionTypeParamName = "expressionType";
    public static final String defaultExpressionValueParamName = "expressionValue";
    private static ThreadLocal<String> expressionType = new ThreadLocal();
    private static ThreadLocal<String> expressionValue = new ThreadLocal();
    private static final Log log = CtpLogFactory.getLog(ListSearchHelper.class);

    public static void remove() {
        expressionType.remove();
        expressionValue.remove();
    }

    public static void pickupExpression(HttpServletRequest request, String[] acceptableExpressionTypes) {
        ListSearchHelper.pickupExpression(request, acceptableExpressionTypes, defaultExpressionTypeParamName, defaultExpressionValueParamName);
    }

    public static void pickupExpression(HttpServletRequest request, String[] acceptableExpressionTypes, String expressionTypeParamName, String expressionValueParamName) {
        ListSearchHelper.remove();
        String et = StringUtils.trimToNull((String)request.getParameter(expressionTypeParamName));
        String ev = StringUtils.trimToNull((String)request.getParameter(expressionValueParamName));
        if (et != null && ev != null) {
            if (acceptableExpressionTypes != null) {
                boolean expressionTypeIsValid = false;
                for (String s : acceptableExpressionTypes) {
                    if (!et.equals(s)) continue;
                    expressionTypeIsValid = true;
                }
                if (!expressionTypeIsValid) {
                    log.warn((Object)("\u65e0\u6548\u7684 " + expressionTypeParamName + " \u503c\uff0c\u5ffd\u7565\uff1a" + et));
                    return;
                }
            }
            expressionType.set(et);
            expressionValue.set(ev);
        }
    }

    public static String getExpressionType() {
        return expressionType.get();
    }

    public static String getExpressionValueString() {
        return expressionValue.get();
    }

    public static Long getExpressionValueLong() {
        String ev = ListSearchHelper.getExpressionValueString();
        try {
            return Long.valueOf(ev);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("\u65e0\u6548\u7684\u6570\u5b57\uff0c\u5ffd\u7565\uff1a" + ev));
            return null;
        }
    }

    public static Boolean getExpressionValueBoolean(boolean collectionType, String[] booleanValues) {
        String ev = ListSearchHelper.getExpressionValueString();
        if (booleanValues != null) {
            for (String b : booleanValues) {
                if (!ev.equalsIgnoreCase(b)) continue;
                return collectionType;
            }
        }
        return !collectionType;
    }

    public static String[] getExpressionValueStringArray(String regex) {
        String ev = ListSearchHelper.getExpressionValueString();
        if (ev == null) {
            return null;
        }
        return ev.split(regex);
    }

    public static Long[] getExpressionValueLongArray(String regex) {
        String ev = ListSearchHelper.getExpressionValueString();
        if (ev == null) {
            return null;
        }
        String[] tokens = ev.split(regex);
        LinkedList<Long> list = new LinkedList<Long>();
        for (String t : tokens) {
            try {
                list.add(Long.valueOf(t));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("\u65e0\u6548\u7684\u6570\u5b57\uff0c\u5ffd\u7565\uff1a" + t));
            }
        }
        Long[] r = new Long[list.size()];
        list.toArray(r);
        return r;
    }

    public static void setQueryNamedParameters(Query query, Map<String, Object> parameters) {
        if (query == null || parameters == null) {
            return;
        }
        for (String pn : parameters.keySet()) {
            Object pv = parameters.get(pn);
            if (pv instanceof Collection) {
                query.setParameterList(pn, (Collection)pv);
                continue;
            }
            query.setParameter(pn, pv);
        }
    }

    public static Object[] getParameterArray(Map<String, Object> parameters) {
        String[] pn = new String[parameters.size()];
        Object[] pv = new Object[parameters.size()];
        int j = 0;
        Iterator<String> iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String k;
            pn[j] = k = iterator.next();
            pv[j] = parameters.get(k);
            ++j;
        }
        return new Object[]{pn, pv};
    }

    public static String encodeBase64(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Base64.encodeBase64(str.getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String decodeBase64(String base64Str) throws UnsupportedEncodingException {
        if (base64Str == null) {
            return null;
        }
        return new String(Base64.decodeBase64(base64Str.getBytes()), "UTF8");
    }
}

