/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;

public class LimitedMap<T1, T2, T3> {
    private int maxLength;
    private Map<T1, T2> map;
    private SortedMap<T3, T1> sortedMap;
    private static Log log = CtpLogFactory.getLog(LimitedMap.class);

    public LimitedMap(int limitLength, List<T1> keys, List<T2> values, List<T3> compares, Comparator<T3> comparator) {
        this.maxLength = limitLength;
        this.map = new HashMap<T1, T2>();
        this.sortedMap = comparator == null ? new TreeMap<T3, T1>(new DefaultComparator()) : new TreeMap<T3, T1>(comparator);
        this.initData(keys, values, compares);
    }

    private void initData(List<T1> keys, List<T2> values, List<T3> compares) {
        if (keys != null) {
            int len = keys.size();
            HashMap<T3, T1> initMap = new HashMap<T3, T1>();
            for (int i = 0; i < len; ++i) {
                T1 key = keys.get(i);
                T2 value = values.get(i);
                T3 compara = compares.get(i);
                this.map.put(key, value);
                initMap.put(compara, key);
            }
            this.sortedMap.putAll(initMap);
        }
    }

    public T2 get(T1 key) {
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T1 add(T1 key, T2 value, T3 compare) {
        Object addIt = key;
        SortedMap<T3, T1> sortedMap = this.sortedMap;
        synchronized (sortedMap) {
            if (this.get(key) != null) {
                this.map.put(key, value);
            } else if (this.sortedMap.size() < this.maxLength) {
                this.sortedMap.put(compare, key);
                this.map.put(key, value);
            } else {
                Comparator<T3> comparator = this.sortedMap.comparator();
                T3 firstComparator = this.sortedMap.firstKey();
                Object firstValue = this.sortedMap.get(firstComparator);
                if (comparator.compare(compare, firstComparator) > 0) {
                    addIt = firstValue;
                    this.map.remove(firstValue);
                    this.sortedMap.remove(firstComparator);
                    this.sortedMap.put(compare, key);
                    this.map.put(key, value);
                } else {
                    addIt = null;
                }
            }
        }
        return addIt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T1 key) {
        SortedMap<T3, T1> sortedMap = this.sortedMap;
        synchronized (sortedMap) {
            Set<Map.Entry<T3, T1>> entries = this.sortedMap.entrySet();
            for (Map.Entry<T3, T1> entry : entries) {
                if (!key.equals(entry.getValue())) continue;
                this.sortedMap.remove(entry.getKey());
                break;
            }
            this.map.remove(key);
        }
    }

    public Map<T1, T2> getMap() {
        return this.map;
    }

    class DefaultComparator
    implements Comparator<T3> {
        DefaultComparator() {
        }

        @Override
        public int compare(T3 one, T3 other) {
            Long t1 = (Long)one;
            Long t2 = (Long)other;
            return t1.compareTo(t2);
        }
    }
}

