/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import org.apache.commons.lang3.StringUtils;

public final class IdentifierUtil {
    public static String newIdentifier(int initialCapacity, char initialValue) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < initialCapacity; ++i) {
            sb.append(initialValue);
        }
        return sb.toString();
    }

    public static String newIdentifier(String originalIdentifier, int capacity, char initialValue) {
        if (originalIdentifier == null) {
            return IdentifierUtil.newIdentifier(capacity, initialValue);
        }
        int increaseSize = capacity - originalIdentifier.length();
        if (increaseSize < 1) {
            return originalIdentifier;
        }
        StringBuilder sb = new StringBuilder(originalIdentifier);
        for (int i = 0; i < increaseSize; ++i) {
            sb.append(initialValue);
        }
        return sb.toString();
    }

    public static Character lookup(String identifier, int index) {
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            return null;
        }
        return Character.valueOf(identifier.charAt(index));
    }

    public static boolean lookupInner(String identifier, int index, char value) {
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            return false;
        }
        return IdentifierUtil.lookup(identifier, index).charValue() == value;
    }

    public static String update(String identifier, int index, char value) {
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            return null;
        }
        char[] cs = identifier.toCharArray();
        cs[index] = value;
        return new String(cs);
    }
}

