/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.dao.paginate.Pagination;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.BasePO;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UniqueList;
import com.seeyon.v3x.common.domain.BaseModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;

public class CommonTools {
    private static final Log logger = CtpLogFactory.getLog(CommonTools.class);
    private static volatile Map<String, CountDownLatch> countDownLatchs = new HashMap<String, CountDownLatch>();

    public static List<Long> parseStrArr2Ids(String[] idStrArray) {
        if (idStrArray != null && idStrArray.length > 0) {
            ArrayList<Long> ret = new ArrayList<Long>(idStrArray.length);
            for (String id : idStrArray) {
                if (!Strings.isNotBlank(id)) continue;
                ret.add(NumberUtils.toLong((String)id.trim()));
            }
            return ret;
        }
        return null;
    }

    public static List<Long> parseStr2Ids(String idStrs, String seperator) {
        if (Strings.isNotBlank(idStrs)) {
            String[] strs = idStrs.split(seperator);
            return CommonTools.parseStrArr2Ids(strs);
        }
        return null;
    }

    public static List<Long> parseStr2Ids(String idStrs) {
        return CommonTools.parseStr2Ids(idStrs, ",");
    }

    public static List<Long> parseStr2Ids(HttpServletRequest request, String parameterName) {
        return CommonTools.parseStr2Ids(request.getParameter(parameterName));
    }

    public static String getTypeAndIdStrs(List<Object[]> typeAndIds) {
        if (CollectionUtils.isNotEmpty(typeAndIds)) {
            UniqueList<String> list = new UniqueList<String>();
            for (Object[] arr : typeAndIds) {
                list.add(arr[0] + "|" + arr[1]);
            }
            return StringUtils.join(list, (String)",");
        }
        return null;
    }

    public static List collectProperty(Collection<? extends BasePO> models, String propertyName) {
        ArrayList<Object> result = null;
        if (CollectionUtils.isNotEmpty(models)) {
            result = new ArrayList<Object>(models.size());
            try {
                for (BasePO basePO : models) {
                    if (basePO == null) continue;
                    result.add(PropertyUtils.getProperty((Object)basePO, (String)propertyName));
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u83b7\u53d6\u9886\u57df\u6a21\u578b\u5c5e\u6027\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return result;
    }

    public static List<Long> getIds(Collection<? extends BasePO> models) {
        ArrayList<Long> result = null;
        if (CollectionUtils.isNotEmpty(models)) {
            result = new ArrayList<Long>();
            for (BasePO basePO : models) {
                if (basePO == null) continue;
                result.add(basePO.getId());
            }
        }
        return result;
    }

    public static Map<String, Object> newHashMap(String[] keys, Object[] values) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (keys == null || values == null || keys.length != values.length) {
            throw new IllegalArgumentException("\u8fd9\u4f4d\u5927\u4fa0\uff0c\u60a8\u7ed9\u51fa\u7684\u952e\u503c\u5bf9\u6570\u636e\u4e3a\u7a7a\u6216\u4e0d\u76f8\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u4e4b\u540e\u518d\u6b21\u6765\u8fc7...");
        }
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            result.put(key, values[i]);
        }
        return result;
    }

    public static <T> ArrayList<T> newArrayList(T ... elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("\u8fd9\u4f4d\u5927\u4fa0\uff0c\u60a8\u5565\u90fd\u4e0d\u7ed9\u5c0f\u7684\uff0c\u6ca1\u6cd5\u7ed9\u60a8\u6253\u5305\u54ea...");
        }
        ArrayList result = new ArrayList(elements.length);
        Collections.addAll(result, elements);
        return result;
    }

    public static Map<String, Object> newHashMap(String key, Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(key, value);
        return result;
    }

    public static List<Long> parseTypeAndIdStr2Ids(String typeAndIds) {
        if (Strings.isNotBlank(typeAndIds)) {
            return CommonTools.parseStr2Ids(typeAndIds.replaceAll("[a-zA-Z]*\\|", ""));
        }
        return null;
    }

    public static <T> List<T> pagenate(List<T> list) {
        return CommonTools.pagenate(list, true);
    }

    public static <T> List<T> pagenate(List<T> list, boolean needCount) {
        if (CollectionUtils.isNotEmpty(list)) {
            Integer first = Pagination.getFirstResult();
            Integer pageSize = Pagination.getMaxResults();
            if (needCount) {
                Pagination.setRowCount(list.size());
            }
            return CommonTools.getSubList(list, first, first + pageSize);
        }
        return new ArrayList(0);
    }

    public static <T> List<T> getSubList(List<T> source, int first, int end) {
        List<Object> result = new ArrayList(0);
        if (CollectionUtils.isNotEmpty(source)) {
            int size = source.size();
            if (first >= size) {
                return result;
            }
            int fromIndex = 0;
            int toIndex = 0;
            if (first >= 0 && first < size) {
                fromIndex = first;
            }
            if (end > size) {
                toIndex = size;
            } else if (end >= 0 && end <= size) {
                toIndex = end;
            }
            result = source.subList(fromIndex, toIndex);
        }
        return result;
    }

    public static <T> List<T> parseArr2List(T[] arr) {
        ArrayList<T> result = null;
        if (arr != null && arr.length > 0) {
            result = new ArrayList<T>(arr.length);
            for (T t : arr) {
                result.add(t);
            }
        }
        return result;
    }

    public static boolean equals(String s1, String s2) {
        return StringUtils.isBlank((CharSequence)s1) ? StringUtils.isBlank((CharSequence)s2) : s1.equals(s2);
    }

    public static String getIdStrs(Collection<? extends BaseModel> models, char joinChar) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(models)) {
            for (BaseModel baseModel : models) {
                if (baseModel == null) continue;
                sb.append(String.valueOf(baseModel.getId()) + joinChar);
            }
        }
        return StringUtils.isNotBlank((CharSequence)sb.toString()) ? sb.substring(0, sb.length() - 1) : sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<Boolean, CountDownLatch> getCountDownLatch(String resourcesKey) {
        CountDownLatch countDownLatch = countDownLatchs.get(resourcesKey);
        boolean isOwer = false;
        if (countDownLatch == null) {
            Map<String, CountDownLatch> map = countDownLatchs;
            synchronized (map) {
                countDownLatch = countDownLatchs.get(resourcesKey);
                if (countDownLatch == null) {
                    countDownLatch = new CountDownLatch(1);
                    isOwer = true;
                    countDownLatchs.put(resourcesKey, countDownLatch);
                }
            }
        }
        return Pair.of((Object)isOwer, (Object)countDownLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execSyncWorker(String resourcesKey, Worker worker) {
        Pair<Boolean, CountDownLatch> pair = CommonTools.getCountDownLatch(resourcesKey);
        if (((Boolean)pair.getLeft()).booleanValue()) {
            try {
                worker.doWork();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            finally {
                Map<String, CountDownLatch> e = countDownLatchs;
                synchronized (e) {
                    ((CountDownLatch)pair.getRight()).countDown();
                    countDownLatchs.remove(resourcesKey);
                }
            }
        } else {
            try {
                ((CountDownLatch)pair.getRight()).await();
            }
            catch (InterruptedException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return (Boolean)pair.getLeft();
    }

    public static interface Worker {
        public void doWork();
    }
}

