/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread.single;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.thread.ThreadValue;
import com.seeyon.ctp.thread.monitor.ThreadMonitor;
import com.seeyon.ctp.thread.single.SingleThreadPool;
import java.io.Serializable;
import org.apache.commons.logging.Log;

public abstract class SingleThread
implements Runnable,
Serializable {
    private static final Log log = CtpLogFactory.getLog(SingleThread.class);
    private static final long serialVersionUID = -4332977777766465821L;
    protected String clazzName = this.getClass().getName();
    private long stamp = System.currentTimeMillis();
    private String threadID = null;
    protected boolean isExit = false;
    protected Thread thread = null;

    public long getStamp() {
        return this.stamp;
    }

    public String getThreadID() {
        return this.threadID;
    }

    @Override
    public void run() {
        long id;
        this.threadID = ThreadValue.getThreadId();
        this.init();
        while (!this.isExit && (id = SingleThreadPool.getThreadId(this.clazzName)) == this.stamp) {
            try {
                this.doService();
            }
            catch (InterruptedException e) {
                if (this.isExit) continue;
                this.isExit = true;
                log.error((Object)("\u7ebf\u7a0b[" + this.clazzName + "]\u88ab\u7ec8\u6b62"), (Throwable)e);
            }
            catch (Throwable e) {
                try {
                    log.error((Object)("\u7ebf\u7a0b[" + this.clazzName + "]\u6267\u884c\u9519\u8bef"), e);
                }
                catch (Throwable ex) {
                    log.error((Object)("\u7ebf\u7a0b[" + this.clazzName + "]\u6267\u884c\u9519\u8bef"));
                    log.error((Object)e.getLocalizedMessage(), e);
                }
            }
        }
        try {
            this.release();
        }
        catch (Throwable e) {
            log.error((Object)"\u91ca\u653e\u7ebf\u7a0b\u8d44\u6e90\u65f6\u9519\u8bef", e);
        }
        this.thread = null;
        try {
            ThreadMonitor.stopMonitor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void release() {
    }

    protected abstract void init();

    public abstract String getDescription();

    protected abstract void doService() throws InterruptedException;
}

