/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.thread.ExChangeQueue;
import com.seeyon.ctp.thread.StopThreadServerMsg;
import com.seeyon.ctp.thread.ThreadRequest;
import com.seeyon.ctp.thread.ThreadServer;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;

public class ThreadPort {
    protected static Log LOGGER = CtpLogFactory.getLog(ThreadPort.class);
    protected final Object lock = new Object();
    private boolean blockRunning = false;
    protected ThreadServer server;
    protected static long flowNo = 1L;
    private int _task = 0;
    protected Object portName = null;
    protected ExChangeQueue queue = new ExChangeQueue();
    protected Semaphore sem = new Semaphore(0);

    public boolean isBlockRunning() {
        return this.blockRunning;
    }

    public void setBlockRunning(boolean _blockRunning) {
        this.blockRunning = _blockRunning;
    }

    public ExChangeQueue getQueue() {
        return this.queue;
    }

    public int getTask() {
        return this._task;
    }

    protected void send(String id, Object data) {
        this.queue.add(id, data);
        this.sem.release();
    }

    public void call(Object request) throws Exception {
        if (this.blockRunning) {
            return;
        }
        String id = ThreadPort.getId();
        this.increaseTask();
        this.send(id, request);
    }

    public ThreadRequest getRequest() throws InterruptedException {
        this.sem.acquire();
        this.decreaseTask();
        return this.queue.get();
    }

    public static synchronized String getId() {
        return String.valueOf(++flowNo);
    }

    public synchronized void increaseTask() {
        ++this._task;
    }

    public synchronized void decreaseTask() {
        --this._task;
    }

    public void startService(Object portName, ThreadServer server) {
        this.server = server;
        this.portName = portName;
        server.setPort(this);
        server.setPortName(portName);
        Thread thread = new Thread(server);
        thread.setDaemon(true);
        thread.start();
    }

    public void stopService() {
        try {
            LOGGER.info((Object)("\u5f00\u59cb\u7ec8\u6b62[ThreadServer]\u7ebf\u7a0b:" + this.portName));
            this.call(new StopThreadServerMsg());
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u7ebf\u7a0b\u7ec8\u6b62", (Throwable)e);
        }
        catch (Throwable e) {
            LOGGER.error((Object)"\u7ec8\u6b62\u7ebf\u7a0b\u65f6\u9519\u8bef", e);
        }
    }

    public void blockExecute() throws Exception {
        this.blockRunning = true;
        this.server.setStartFlag(true);
        try {
            this.block();
        }
        catch (Throwable ex) {
            this.close();
        }
    }

    public void close() {
        LOGGER.info((Object)"\u5173\u95ed\u963b\u585e\u6267\u884c!");
        this.unblock();
        this.server.setStartFlag(false);
        this.blockRunning = false;
        this.sem = new Semaphore(0);
        this.queue = new ExChangeQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() {
        LOGGER.info((Object)("\u5f00\u59cb\u8fdb\u5165\u963b\u585e\u6267\u884c\u72b6\u6001\uff0c\u7b49\u5f85\u6267\u884c\u4efb\u52a1\u6570\uff1a" + this._task + "\u4e2a!"));
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unblock() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }
}

