/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.thread.CTPThreadServer;
import com.seeyon.ctp.thread.StopThreadServerMsg;
import com.seeyon.ctp.thread.ThreadManager;
import com.seeyon.ctp.thread.ThreadRequest;
import org.apache.commons.logging.Log;

public abstract class BlockThreadServer
extends CTPThreadServer {
    private static final Log LOGGER = CtpLogFactory.getLog(BlockThreadServer.class);
    private static int _count;

    public BlockThreadServer(Integer count) {
        super(count);
        _count = count;
        this.startFlag = false;
    }

    @Override
    public void run() {
        LOGGER.info((Object)("\u542f\u52a8\u7ebf\u7a0b[MThread Server]:" + this.getPortName()));
        ThreadManager.getInstance().register(this.getPortName(), this.getPort());
        ThreadRequest request = null;
        while (this.continueFlag) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.startFlag) continue;
            if (this.getPort().getTask() == 0) {
                if (this.sem.availablePermits() != _count) continue;
                this.getPort().close();
            }
            try {
                this.sem.acquire();
                request = this.getPort().getRequest();
                Object data = request.getData();
                if (data instanceof StopThreadServerMsg) {
                    this.continueFlag = false;
                    this.destroy();
                    ThreadManager.getInstance().remove(this.getPortName());
                    continue;
                }
                CTPThreadServer.Worker worker = new CTPThreadServer.Worker(this, data);
                new Thread(worker).start();
            }
            catch (Throwable ex) {
                this.sem.release();
                LOGGER.debug((Object)"\u8fdb\u7a0b\u95f4\u901a\u4fe1\u5b88\u62a4\u8fdb\u7a0b\u51fa\u73b0\u9519\u8bef\uff01", (Throwable)new Exception("\u8c03\u7528JAVA\u670d\u52a1\u65f6\u5f02\u5e38\u9519\u8bef:" + ex));
            }
        }
    }
}

