/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.session;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.login.online.OnlineRecorder;
import com.seeyon.ctp.login.online.OnlineUser;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;

public class SessionExpiringMap {
    private Map<Key, Object> data = new ConcurrentHashMap<Key, Object>();
    private static Log LOG = CtpLogFactory.getLog(SessionExpiringMap.class);

    public SessionExpiringMap() {
        new SessionCleanThread().start();
    }

    public void put(String key, Object value, String sessionId) {
        if (value == null) {
            this.remove(key, sessionId);
            return;
        }
        this.data.put(this.buildKey(key, sessionId), value);
    }

    public Object get(String key, String sessionId) {
        return this.data.get(this.buildKey(key, sessionId));
    }

    public Object remove(String key, String sessionId) {
        return this.data.remove(this.buildKey(key, sessionId));
    }

    public void removeAllExpired() {
        Set<Key> keySet = this.data.keySet();
        HashSet<Key> expiredSet = new HashSet<Key>();
        int size = keySet.size();
        for (Key key : keySet) {
            if (!key.isExpired()) continue;
            expiredSet.add(key);
        }
        LOG.info((Object)("Session\uff1a\u5171 " + size + " \u6761\uff0c\u672c\u6b21\u5171\u6e05\u7406 " + expiredSet.size() + " \u6761\u3002"));
        keySet.removeAll(expiredSet);
    }

    private Key buildKey(String key, String sessionId) {
        Key k = new Key(AppContext.currentUserLoginName(), sessionId, key);
        return k;
    }

    private String getSessionId() {
        HttpSession session = AppContext.getRawSession();
        if (session == null) {
            return Thread.currentThread().getName();
        }
        return session.getId();
    }

    public Set<String> getAllSession() {
        HashSet<String> result = new HashSet<String>();
        for (Key key : this.data.keySet()) {
            result.add(key.getSessionId());
        }
        return result;
    }

    public Map getBySession(String sessionId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Key key : this.data.keySet()) {
            if (!key.getSessionId().equals(sessionId)) continue;
            result.put(key.getKey(), this.data.get(key));
        }
        return result;
    }

    private boolean isExpired(String loginName, String sessionId) {
        OnlineUser onlineUser = OnlineRecorder.getOnlineUser((String)loginName);
        if (onlineUser == null) {
            return true;
        }
        for (OnlineUser.LoginInfo info : onlineUser.getLoginInfoMap().values()) {
            if (!info.getSessionId().equals(sessionId)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return JSONUtil.toJSONString(this.data);
    }

    class Key {
        private String sessionId;
        private String loginName;
        private String key;

        public String toString() {
            return "Key [sessionId=" + this.sessionId + ", loginName=" + this.loginName + ", key=" + this.key + "]";
        }

        public Key(String loginName, String sessionId, String key) {
            this.loginName = loginName;
            this.sessionId = sessionId;
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.loginName == null ? 0 : this.loginName.hashCode());
            result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.loginName == null ? other.loginName != null : !this.loginName.equals(other.loginName)) {
                return false;
            }
            return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
        }

        public String getLoginName() {
            return this.loginName;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isExpired() {
            return SessionExpiringMap.this.isExpired(this.loginName, this.sessionId);
        }

        private SessionExpiringMap getOuterType() {
            return SessionExpiringMap.this;
        }
    }

    class SessionCleanThread
    extends Thread {
        private long PERIOD = 600000L;
        private boolean running = true;

        public SessionCleanThread() {
            super.setName("SessionCleanThread");
        }

        @Override
        public synchronized void start() {
            super.start();
            LOG.info((Object)"Session\u81ea\u52a8\u6e05\u7406\u8fdb\u7a0b\u542f\u52a8");
        }

        private long getPeriod() {
            int size = SessionExpiringMap.this.data.size();
            if (size > 10000) {
                return 60000L;
            }
            if (size < 1000) {
                return 1200000L;
            }
            return this.PERIOD;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    SessionExpiringMap.this.removeAllExpired();
                }
                catch (Exception e) {
                    LOG.error((Object)("\u6e05\u7406Session\u51fa\u9519:" + e.getLocalizedMessage()), (Throwable)e);
                }
                try {
                    Thread.sleep(this.getPeriod());
                }
                catch (Exception e) {
                    LOG.error((Object)"", (Throwable)e);
                }
            }
        }
    }
}

