/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.session;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.session.MapSession;
import com.seeyon.ctp.util.Strings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.session.ExpiringSession;
import org.springframework.session.SessionRepository;

public class CTPMapSessionRepository
implements SessionRepository<ExpiringSession> {
    private Integer defaultMaxInactiveInterval;
    private final Map<String, ExpiringSession> sessions;
    private String jvmRout = null;

    public CTPMapSessionRepository() {
        this(new ConcurrentHashMap<String, ExpiringSession>());
        this.jvmRout = SystemEnvironment.getJvmRoute();
        if (Strings.isBlank(this.jvmRout) || "\u672a\u914d\u7f6e".equals(this.jvmRout)) {
            this.jvmRout = null;
        }
    }

    public CTPMapSessionRepository(Map<String, ExpiringSession> sessions) {
        if (sessions == null) {
            throw new IllegalArgumentException("sessions cannot be null");
        }
        this.sessions = sessions;
    }

    public void setDefaultMaxInactiveInterval(int defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void save(ExpiringSession session) {
        this.sessions.put(session.getId(), session);
    }

    public ExpiringSession getSession(String id) {
        ExpiringSession saved = this.sessions.get(id);
        if (saved == null) {
            return null;
        }
        if (saved.isExpired()) {
            this.delete(saved.getId());
            return null;
        }
        if (saved instanceof MapSession) {
            ((MapSession)saved).setLastAccessedTime(System.currentTimeMillis());
        }
        return saved;
    }

    public void delete(String id) {
        this.sessions.remove(id);
    }

    public ExpiringSession createSession() {
        MapSession result = new MapSession();
        if (this.defaultMaxInactiveInterval != null) {
            result.setMaxInactiveIntervalInSeconds(this.defaultMaxInactiveInterval);
        }
        return result;
    }
}

