/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.monitor.manager;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.monitor.manager.MaintenceManager;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.ZipUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.logging.Log;

public class MaintenceManagerImpl
implements MaintenceManager {
    private static Log log = CtpLogFactory.getLog(MaintenceManagerImpl.class);
    private static final Comparator<File> lastModified = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o1.lastModified() == o2.lastModified() ? 0 : (o1.lastModified() < o2.lastModified() ? 1 : -1);
        }
    };

    @Override
    public String packLog(String date) {
        String seeyonLogPath = SystemEnvironment.getApplicationFolder() + "/logs/";
        String tomcatLogPath = seeyonLogPath + "../../../logs/";
        File tempSeeyonLog = new File(seeyonLogPath + "tempSeeyonLog.zip");
        File seeyonLogPack = new File(seeyonLogPath + "SeeyonLogPack_" + date + ".zip");
        try {
            File seeyonLogDirectory;
            if (seeyonLogPack.exists()) {
                seeyonLogPack.delete();
            }
            if ((seeyonLogDirectory = new File(seeyonLogPath + date)).exists()) {
                ZipUtil.zip(seeyonLogDirectory, tempSeeyonLog, true);
            } else {
                ZipUtil.zip(Arrays.asList(new File(seeyonLogPath).listFiles()), tempSeeyonLog);
            }
            ArrayList<File> needPackFiles = new ArrayList<File>();
            File[] files = new File(tomcatLogPath).listFiles();
            Arrays.sort(files, lastModified);
            int i = 0;
            for (File tomcatLog : files) {
                if (!tomcatLog.getName().startsWith("catalina") || tomcatLog.lastModified() <= Datetimes.parse(date).getTime()) continue;
                needPackFiles.add(tomcatLog);
                if (i++ > 2) break;
            }
            needPackFiles.add(tempSeeyonLog);
            ZipUtil.zip(needPackFiles, seeyonLogPack);
            tempSeeyonLog.delete();
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return seeyonLogPack.getName();
    }
}

