/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.login;

import com.seeyon.ctp.login.LoginExtensionBean;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.DirectoryScanner;

public class LoginExtensionBeanLoader {
    private static final Log logger = LogFactory.getLog(LoginExtensionBeanLoader.class);
    private static LoginExtensionBeanLoader INSTANCE = new LoginExtensionBeanLoader();
    private MultiValueMap beforeMap;
    private MultiValueMap afterMap;
    private List tailList;

    private LoginExtensionBeanLoader() {
    }

    public static LoginExtensionBeanLoader getInstance() {
        return INSTANCE;
    }

    public void init(String cfgHome) throws Exception {
        this.beforeMap = new MultiValueMap();
        this.afterMap = new MultiValueMap();
        this.tailList = new ArrayList();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(cfgHome);
        ds.setIncludes(new String[]{"login.xml", "plugin/*/login.xml"});
        ds.scan();
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            logger.info((Object)("\u89e3\u6790\u767b\u5f55\u6269\u5c55\u914d\u7f6e\u6587\u4ef6" + files[i]));
            List<LoginExtensionBean> beans = this.parseLoginBean(new File(cfgHome + "/" + files[i]));
            for (LoginExtensionBean bean : beans) {
                String before = bean.getBefore();
                String after = bean.getAfter();
                Object o = Class.forName(bean.getClassName()).newInstance();
                if (!Strings.isEmpty(before)) {
                    this.beforeMap.put((Object)before, o);
                    continue;
                }
                if (!Strings.isEmpty(after)) {
                    this.afterMap.put((Object)after, o);
                    continue;
                }
                this.tailList.add(o);
            }
        }
    }

    private List<LoginExtensionBean> parseLoginBean(File file) throws Exception {
        Digester d = new Digester();
        d.setValidating(false);
        d.push(new ArrayList());
        d.addSetProperties("login");
        d.addObjectCreate("login/bean", LoginExtensionBean.class);
        d.addSetProperties("login/bean");
        d.addBeanPropertySetter("login/bean/class", "className");
        d.addSetProperties("login/bean", "class", "className");
        d.addSetNext("login/bean", "add");
        return (List)d.parse(file);
    }

    public <T> List<T> getBefore(String className, Class<T> clazz) {
        return this.filter(className, clazz, this.beforeMap);
    }

    public <T> List<T> getAfter(String className, Class<T> clazz) {
        return this.filter(className, clazz, this.afterMap);
    }

    public <T> List<T> getTail(Class<T> clazz) {
        return this.filter(clazz, this.tailList);
    }

    private <T> List<T> filter(String className, Class<T> clazz, MultiValueMap m) {
        return this.filter(clazz, m.getCollection((Object)className));
    }

    private <T> List<T> filter(Class<T> clazz, Collection collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        ArrayList l = new ArrayList();
        for (Object o : collection) {
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            l.add(o);
        }
        return l;
    }

    public <T> Map<String, T> getLoginAuthentications(Map<String, T> source, Class<T> clazz) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>();
        for (String key : source.keySet()) {
            List<T> before = this.getBefore(key, clazz);
            this.append(result, before);
            result.put(key, source.get(key));
            List<T> after = this.getAfter(key, clazz);
            this.append(result, after);
        }
        this.append(result, this.tailList);
        return result;
    }

    private <T> void append(Map<String, T> result, List<T> list) {
        for (T t : list) {
            result.put(t.getClass().getCanonicalName(), t);
        }
    }
}

