/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.event;

import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.Listener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ListenerRegistry {
    private static final ListenerRegistry INSTANCE = new ListenerRegistry();
    private byte[] lock = new byte[0];
    private Map<String, List<Listener>> listenerMap = new HashMap<String, List<Listener>>();

    private ListenerRegistry() {
    }

    public static final ListenerRegistry getInstance() {
        return INSTANCE;
    }

    public Map<String, List<Listener>> getAllListener() {
        return new HashMap<String, List<Listener>>(this.listenerMap);
    }

    public List<Listener> getListener(Class<? extends Event> eventType) {
        String key = this.buildKey(eventType);
        List<Listener> listeners = this.listenerMap.get(key);
        return listeners == null ? Collections.emptyList() : listeners;
    }

    private String buildKey(Class<? extends Event> eventType) {
        return eventType.getCanonicalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class<? extends Event> eventType, Listener listener) {
        String key = this.buildKey(eventType);
        List<Listener> list = this.listenerMap.get(key);
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (list == null) {
                list = new ArrayList<Listener>();
                this.listenerMap.put(key, list);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            list.add(listener);
            return;
        }
    }
}

