/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.event;

import com.google.common.collect.Lists;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventTriggerMode;
import com.seeyon.ctp.event.FireEventThread;
import com.seeyon.ctp.event.ListenEventAnnotationAware;
import com.seeyon.ctp.event.Listener;
import com.seeyon.ctp.event.ListenerRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class EventDispatcher {
    private static final Log logger = CtpLogFactory.getLog(EventDispatcher.class);
    private static final ThreadLocal<Boolean> stopDispatching = new ThreadLocal();
    private static final ExecutorService asynEventExecutors = new ThreadPoolExecutor(10, 20, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactory(){
        private AtomicInteger threadNum = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ASYN_EVENT" + this.threadNum.incrementAndGet());
        }
    }, new ThreadPoolExecutor.CallerRunsPolicy());

    public static final void fireEvent(final Event event) {
        List<Listener> listeners = EventDispatcher.getListeners(event);
        if (CollectionUtils.isEmpty(listeners)) {
            EventDispatcher.log("\u6ca1\u6709\u6ce8\u518c\u4e8b\u4ef6\u76d1\u542c\u5668\uff1a" + event);
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            final AtomicBoolean dispatchAfterCommit = new AtomicBoolean(false);
            final ArrayList afterCommits = Lists.newArrayList();
            for (Listener listener : listeners) {
                if (!listener.isEnabled()) {
                    logger.info((Object)("\u4e8b\u4ef6:[" + event.getClass() + "]\u7684\u76d1\u542c\u5668[" + listener + "]\u5df2\u88ab\u505c\u7528\uff0c\u4e0d\u518d\u89e6\u53d1..."));
                }
                if (listener.async()) {
                    if (EventTriggerMode.immediately.equals((Object)listener.getMode())) {
                        EventDispatcher.log("\u76d1\u542c\u5668[" + listener + "@async=true,mode=immediately]\u5ffd\u7565mode\u5c5e\u6027");
                    }
                    afterCommits.add(listener);
                    dispatchAfterCommit.set(true);
                    continue;
                }
                EventDispatcher.syncExecute(event, listener);
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    for (Listener listener : afterCommits) {
                        EventDispatcher.asyncExecute(event, listener);
                    }
                    if (dispatchAfterCommit.get()) {
                        EventDispatcher.senDistributedEvent(event);
                    }
                }
            });
            if (!dispatchAfterCommit.get()) {
                EventDispatcher.senDistributedEvent(event);
            }
        } else {
            EventDispatcher.nonTransactionExecute(event, listeners);
        }
    }

    public static final void fireEventAfterCommit(final Event event) {
        final List<Listener> listeners = EventDispatcher.getListeners(event);
        if (CollectionUtils.isEmpty(listeners)) {
            EventDispatcher.log("\u6ca1\u6709\u6ce8\u518c\u4e8b\u4ef6\u76d1\u542c\u5668\uff1a" + event);
            return;
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    for (Listener listener : listeners) {
                        if (!listener.isEnabled()) {
                            logger.info((Object)("\u4e8b\u4ef6:[" + event.getClass() + "]\u7684\u76d1\u542c\u5668[" + listener + "]\u5df2\u88ab\u505c\u7528\uff0c\u4e0d\u518d\u89e6\u53d1..."));
                        }
                        EventDispatcher.log("\u4e8b\u52a1\u63d0\u4ea4\u540e\u6267\u884c[\u4e8b\u4ef6\uff1a" + event + "],[\u76d1\u542c\u5668:" + listener + "]");
                        if (listener.async()) {
                            EventDispatcher.asyncExecute(event, listener);
                            continue;
                        }
                        EventDispatcher.syncExecute(event, listener);
                    }
                    EventDispatcher.senDistributedEvent(event);
                }
            });
        } else {
            EventDispatcher.nonTransactionExecute(event, listeners);
        }
    }

    public static final void fireEventWithException(final Event event) throws Throwable {
        List<Listener> listeners = EventDispatcher.getListeners(event);
        if (CollectionUtils.isEmpty(listeners)) {
            EventDispatcher.log("\u6ca1\u6709\u6ce8\u518c\u4e8b\u4ef6\u76d1\u542c\u5668\uff1a" + event);
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            final AtomicBoolean dispatchAfterCommit = new AtomicBoolean(false);
            final ArrayList afterCommits = Lists.newArrayList();
            for (Listener listener : listeners) {
                if (!listener.isEnabled()) {
                    logger.info((Object)("\u4e8b\u4ef6:[" + event.getClass() + "]\u7684\u76d1\u542c\u5668[" + listener + "]\u5df2\u88ab\u505c\u7528\uff0c\u4e0d\u518d\u89e6\u53d1..."));
                }
                if (listener.async()) {
                    if (EventTriggerMode.immediately.equals((Object)listener.getMode())) {
                        EventDispatcher.log("\u76d1\u542c\u5668[" + listener + "@async=true,mode=immediately]\u5ffd\u7565mode\u5c5e\u6027");
                    }
                    afterCommits.add(listener);
                    dispatchAfterCommit.set(true);
                    continue;
                }
                EventDispatcher.log("\u540c\u6b65\u6267\u884c[listener=" + listener + "], \u4e8b\u4ef6=" + event + "\u5f00\u59cb:");
                listener.handle(event, false);
                EventDispatcher.log("\u540c\u6b65\u6267\u884c[listener=" + listener + "], \u4e8b\u4ef6=" + event + "\u6210\u529f!");
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    for (Listener listener : afterCommits) {
                        EventDispatcher.asyncExecute(event, listener);
                    }
                    if (dispatchAfterCommit.get()) {
                        EventDispatcher.senDistributedEvent(event);
                    }
                }
            });
            if (!dispatchAfterCommit.get()) {
                EventDispatcher.senDistributedEvent(event);
            }
        } else {
            EventDispatcher.nonTransactionExecute(event, listeners);
        }
    }

    private static void senDistributedEvent(Event event) {
        if (SystemEnvironment.isDistributedMode() && (stopDispatching.get() == null || !stopDispatching.get().booleanValue())) {
            RedisHandler.pubSeeyonEvent(event);
        }
    }

    private static List<Listener> getListeners(Event event) {
        ListenerRegistry registry = ListenerRegistry.getInstance();
        List<Listener> listeners = registry.getListener(event.getClass());
        ArrayList annoListeners = Lists.newArrayList();
        ArrayList otherListenrs = Lists.newArrayList();
        for (Listener listener : listeners) {
            if (listener instanceof ListenEventAnnotationAware.AnnotationReflectListener) {
                annoListeners.add((ListenEventAnnotationAware.AnnotationReflectListener)listener);
                continue;
            }
            otherListenrs.add(listener);
        }
        Collections.sort(annoListeners, new Comparator<ListenEventAnnotationAware.AnnotationReflectListener>(){

            @Override
            public int compare(ListenEventAnnotationAware.AnnotationReflectListener o1, ListenEventAnnotationAware.AnnotationReflectListener o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        ArrayList list = Lists.newArrayListWithCapacity((int)listeners.size());
        list.addAll(annoListeners);
        list.addAll(otherListenrs);
        return list;
    }

    public Map<String, List<Listener>> getAllListener() {
        return ListenerRegistry.getInstance().getAllListener();
    }

    private static void nonTransactionExecute(Event event, List<Listener> listeners) {
        for (Listener listener : listeners) {
            try {
                if (listener.async()) {
                    EventDispatcher.asyncExecute(event, listener);
                    continue;
                }
                EventDispatcher.syncExecute(event, listener);
            }
            catch (Throwable throwable) {}
        }
        EventDispatcher.senDistributedEvent(event);
    }

    private static void syncExecute(Event event, Listener listener) {
        EventDispatcher.log("\u540c\u6b65\u6267\u884c[listener=" + listener + "], \u4e8b\u4ef6=" + event + "\u5f00\u59cb:");
        try {
            listener.handle(event);
        }
        catch (Throwable t) {
            logger.error((Object)"--- \u6267\u884c\u65f6\u95f4\u76d1\u542c\u51fa\u9519", t);
        }
        EventDispatcher.log("\u540c\u6b65\u6267\u884c[listener=" + listener + "], \u4e8b\u4ef6=" + event + "\u6210\u529f!");
    }

    private static void asyncExecute(Event event, Listener listener) {
        EventDispatcher.log("\u5f02\u6b65\u6267\u884c[listener=" + listener + "], \u4e8b\u4ef6=" + event + "\u5f00\u59cb:");
        FireEventThread task = new FireEventThread(event, listener);
        asynEventExecutors.submit(task);
    }

    private static void log(String msg) {
        if (logger.isDebugEnabled() || SystemEnvironment.isDev()) {
            logger.info((Object)msg);
        }
    }

    public static final void register(Class<? extends Event> eventType, Listener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u6ce8\u518c\u4e8b\u4ef6\u76d1\u542c\uff1a" + eventType + ":" + listener));
        }
        ListenerRegistry.getInstance().register(eventType, listener);
    }

    public static final void register(Class<? extends Event> event, String beanName, String methodName, boolean async) {
        EventDispatcher.register(event, beanName, methodName, async, EventTriggerMode.immediately);
    }

    public static final void register(Class<? extends Event> event, String beanName, String methodName, boolean async, EventTriggerMode mode) {
        try {
            ListenEventAnnotationAware.AnnotationReflectListener listener = new ListenEventAnnotationAware.AnnotationReflectListener(beanName, methodName, event);
            listener.async(async);
            listener.setMode(mode);
            EventDispatcher.register(event, listener);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void stopDispatching() {
        stopDispatching.set(true);
    }

    public static void continueDispatching() {
        stopDispatching.remove();
    }
}

