/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.config.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CipherUtil {
    private static final Log LOG = LogFactory.getLog(CipherUtil.class);
    private static final String KEY_ALGORITHM = "DES";

    CipherUtil() {
    }

    public static byte[] encrypt(String data, String key) throws Exception {
        return CipherUtil.encrypt(CipherUtil.buildDESKey(key), data.getBytes("UTF-8"));
    }

    private static SecretKey buildDESKey(String key) throws InvalidKeyException, UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeySpecException {
        DESKeySpec deskey = new DESKeySpec(key.getBytes("UTF-8"));
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generateSecret(deskey);
    }

    public static byte[] encrypt(Key key, byte[] data) throws Exception {
        try {
            SecureRandom sr = new SecureRandom();
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(1, key, sr);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
    }

    public static byte[] decrypt(String data, String key) throws Exception {
        return CipherUtil.decrypt(data.getBytes("UTF-8"), key);
    }

    public static byte[] decrypt(byte[] data, String key) throws Exception {
        try {
            return CipherUtil.decrypt(CipherUtil.buildDESKey(key), data);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
    }

    public static byte[] decrypt(Key key, byte[] encryptData) throws Exception {
        Cipher cliper = Cipher.getInstance(KEY_ALGORITHM);
        SecureRandom sr = new SecureRandom();
        cliper.init(2, key, sr);
        return cliper.doFinal(encryptData);
    }
}

