/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.web.interceptor;

import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.util.Cookies;
import com.seeyon.ctp.util.annotation.AnnotationAware;
import com.seeyon.ctp.util.annotation.AnnotationFactory;
import com.seeyon.ctp.util.annotation.ClassAnnotation;
import com.seeyon.ctp.util.annotation.MethodAnnotation;
import com.seeyon.ctp.util.annotation.NeedlessCheckLogin;
import com.seeyon.ctp.util.annotation.SetContentType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CommonInterceptor
extends HandlerInterceptorAdapter
implements AnnotationAware {
    private Map<String, Set<String>> noCheckURL = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> noSetContentTypeURL = new HashMap<String, Set<String>>();

    public void init() {
    }

    public void setNoCheckURL(Map<String, Set<String>> noCheckURL) {
        this.marge(noCheckURL);
    }

    public void setNoSetContentTypeURL(Map<String, Set<String>> noSetContentTypeURL) {
        if (this.noCheckURL == null) {
            return;
        }
        Set<String> enities = this.noCheckURL.keySet();
        for (String key : enities) {
            if (this.noSetContentTypeURL.containsKey(key)) {
                this.noSetContentTypeURL.get(key).addAll((Collection<String>)this.noCheckURL.get(key));
                continue;
            }
            HashSet s = new HashSet();
            s.addAll(this.noCheckURL.get(key));
            this.noSetContentTypeURL.put(key, s);
        }
    }

    private <T extends Collection<String>> void marge(Map<String, T> noCheckURL) {
        if (noCheckURL == null) {
            return;
        }
        Set<String> enities = noCheckURL.keySet();
        for (String key : enities) {
            if (this.noCheckURL.containsKey(key)) {
                this.noCheckURL.get(key).addAll((Collection)noCheckURL.get(key));
                continue;
            }
            HashSet s = new HashSet();
            s.addAll((Collection)noCheckURL.get(key));
            this.noCheckURL.put(key, s);
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object object, Exception exception) throws Exception {
    }

    private boolean checkSessionPre(HttpServletRequest request, HttpServletResponse response, String clazz, String method) throws Exception {
        return true;
    }

    private boolean isFromMobile(HttpServletRequest request, User currentUser) {
        if (currentUser != null) {
            return Constants.login_useragent_from.mobile.name().equals(currentUser.getUserAgentFrom());
        }
        String fromCookies = Cookies.get(request, "u_login_from");
        return Constants.login_useragent_from.mobile.name().equals(fromCookies);
    }

    private void setContentTypePre(HttpServletRequest request, HttpServletResponse response, String clazz, String method) {
    }

    @Override
    public void setAnnotationFactory(AnnotationFactory annotationFactory) {
        Set<String> s;
        String key;
        Set<ClassAnnotation> classAnnotations = annotationFactory.getAnnotationOfClass(NeedlessCheckLogin.class);
        Set<MethodAnnotation> methodAnnotation = annotationFactory.getAnnotationOfMethod(NeedlessCheckLogin.class);
        if (classAnnotations != null) {
            for (ClassAnnotation classAnnotation : classAnnotations) {
                key = classAnnotation.getClazz().getCanonicalName();
                s = this.noCheckURL.get(key);
                if (s == null) {
                    s = new HashSet<String>();
                    this.noCheckURL.put(key, s);
                }
                s.add("*");
            }
        }
        if (methodAnnotation != null) {
            for (MethodAnnotation methodAnnotation2 : methodAnnotation) {
                key = methodAnnotation2.getClazz().getCanonicalName();
                s = this.noCheckURL.get(key);
                if (s == null) {
                    s = new HashSet<String>();
                    this.noCheckURL.put(key, s);
                }
                s.add(methodAnnotation2.getMethodName());
            }
        }
        classAnnotations = annotationFactory.getAnnotationOfClass(SetContentType.class);
        methodAnnotation = annotationFactory.getAnnotationOfMethod(SetContentType.class);
        if (classAnnotations != null) {
            for (ClassAnnotation classAnnotation : classAnnotations) {
                key = classAnnotation.getClazz().getCanonicalName();
                s = this.noSetContentTypeURL.get(key);
                if (s == null) {
                    s = new HashSet<String>();
                    this.noSetContentTypeURL.put(key, s);
                }
                s.add("*");
            }
        }
        if (methodAnnotation != null) {
            for (MethodAnnotation methodAnnotation3 : methodAnnotation) {
                key = methodAnnotation3.getClazz().getCanonicalName();
                s = this.noSetContentTypeURL.get(key);
                if (s == null) {
                    s = new HashSet<String>();
                    this.noSetContentTypeURL.put(key, s);
                }
                s.add(methodAnnotation3.getMethodName());
            }
        }
    }
}

