/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.web.filter;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.ServerTypeEnum;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.util.Strings;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CTPRequestFacade
extends HttpServletRequestWrapper
implements HttpServletRequest {
    private static final boolean isWebsphere = ServerTypeEnum.WebSphere == SystemEnvironment.getServerType();
    private static final boolean isTongWeb = ServerTypeEnum.TongWeb == SystemEnvironment.getServerType();
    private static final Charset Charset_UTF8 = Charset.forName("UTF-8");
    private static final Charset Charset_ISO8859_1 = Charset.forName("ISO-8859-1");
    private static final Map<String, String> URL_PARAM_REPLACE_MAP = new HashMap<String, String>();
    private final Map<String, String[]> params = new HashMap<String, String[]>();
    private String decryptPasswordCache;
    private Set<String> urlParamList;

    public String getServerName() {
        return Strings.getServerName(this);
    }

    public CTPRequestFacade(HttpServletRequest request) {
        super(request);
        String queryStr = request.getQueryString();
        if (queryStr != null) {
            String[] params;
            for (String param : params = queryStr.split("&")) {
                String[] keyValue = param.split("=");
                String key = keyValue[0];
                if ("method".equals(key)) continue;
                if (this.urlParamList == null) {
                    this.urlParamList = new HashSet<String>();
                }
                this.urlParamList.add(key);
            }
        }
    }

    public String getParameter(String paramName) {
        boolean requireDecode;
        String[] arr = this.getParameterValues(paramName);
        String result = arr == null ? null : arr[0];
        boolean bl = requireDecode = "login_password".equals(paramName) && SecurityHelper.isCryptPassword();
        if (requireDecode) {
            boolean bl2 = requireDecode ? !"1".equals(this.getParameter("useClearPassword")) : (requireDecode = false);
            if (requireDecode) {
                if (this.decryptPasswordCache == null) {
                    this.decryptPasswordCache = SecurityHelper.decrypt(result);
                }
                if (!"".equals(this.decryptPasswordCache)) {
                    result = this.decryptPasswordCache;
                }
            }
        }
        if (result != null && this.urlParamList != null && this.urlParamList.contains(paramName)) {
            for (String key : URL_PARAM_REPLACE_MAP.keySet()) {
                result = result.replaceAll(key, URL_PARAM_REPLACE_MAP.get(key));
            }
        }
        return result;
    }

    public Map getParameterMap() {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        Enumeration parameters = this.getParameterNames();
        while (parameters.hasMoreElements()) {
            String paramName = (String)parameters.nextElement();
            params.put(paramName, this.getParamValues(paramName));
        }
        return params;
    }

    public Map getOriginParameterMap() {
        return this.params;
    }

    private String[] getParamValues(String paramName) {
        if (this.params.containsKey(paramName)) {
            return this.params.get(paramName);
        }
        String[] paramValues = this._getHttpServletRequest().getParameterValues(paramName);
        if (paramValues == null) {
            return null;
        }
        boolean requireTrans = true;
        if (this.urlParamList != null) {
            boolean bl = requireTrans = !this.urlParamList.contains(paramName);
        }
        if (isWebsphere || isTongWeb) {
            requireTrans = false;
        }
        if (requireTrans) {
            for (int i = 0; i < paramValues.length; ++i) {
                paramValues[i] = new String(paramValues[i].getBytes(Charset_ISO8859_1), Charset_UTF8);
            }
        }
        this.params.put(paramName, paramValues);
        return paramValues;
    }

    public Enumeration getParameterNames() {
        return this._getHttpServletRequest().getParameterNames();
    }

    public String[] getParameterValues(String paramName) {
        return this.getParamValues(paramName);
    }

    private HttpServletRequest _getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }
}

