/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.thirdparty.menu;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.thirdparty.menu.MenuItemAccessCheck;
import com.seeyon.ctp.common.thirdparty.menu.ThirdpartyAddinMenu;
import com.seeyon.ctp.common.thirdparty.menu.ThirdpartyMenu;
import com.seeyon.ctp.common.thirdparty.menu.ThirdpartyMenuManager;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AddinMenuInterceptor
extends HandlerInterceptorAdapter {
    private static final Log log = CtpLogFactory.getLog(AddinMenuInterceptor.class);

    public void init() {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
        if (modelAndView == null) {
            return;
        }
        String viewName = modelAndView.getViewName();
        if (viewName == null) {
            return;
        }
        List<ThirdpartyMenu> menus = ThirdpartyMenuManager.getInstance().getMenus(viewName);
        if (menus.size() > 0) {
            ArrayList<ThirdpartyAddinMenu> addinMenus = new ArrayList<ThirdpartyAddinMenu>();
            for (ThirdpartyMenu menu : menus) {
                if (!(menu instanceof ThirdpartyAddinMenu) || !this.isShowAddinMenu((ThirdpartyAddinMenu)menu, request, modelAndView)) continue;
                addinMenus.add((ThirdpartyAddinMenu)menu);
            }
            modelAndView.addObject("AddinMenus", addinMenus);
        }
    }

    public boolean isShowAddinMenu(ThirdpartyAddinMenu menu, HttpServletRequest request, ModelAndView modelAndView) {
        MenuItemAccessCheck accessCheck = menu.getAccessCheck();
        if (accessCheck != null) {
            return accessCheck.check(AppContext.getCurrentUser().getId(), request, modelAndView);
        }
        List<String> roles = menu.getRoles();
        if (roles != null) {
            // empty if block
        }
        return true;
    }
}

