/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.security;

import com.seeyon.ctp.common.security.SM3Digest;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.codec.binary.Base64;

public class MessageEncoder {
    private static final String ENCODING = "UTF-8";
    private static final String SM3 = "SM3";
    private MessageDigest digester;
    private SM3Digest sm3Digester;
    private static Invocable invocableEngine;

    public MessageEncoder() throws NoSuchAlgorithmException {
        this("SHA-1");
    }

    public MessageEncoder(String algorithm) throws NoSuchAlgorithmException {
        if (SM3.equals(algorithm)) {
            this.sm3Digester = new SM3Digest();
        } else {
            this.digester = MessageDigest.getInstance(algorithm);
        }
    }

    public MessageEncoder(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (SM3.equals(algorithm)) {
            this.sm3Digester = new SM3Digest();
        } else {
            this.digester = MessageDigest.getInstance(algorithm, provider);
        }
    }

    public String getAlgorithm() {
        return this.digester != null ? this.digester.getAlgorithm() : SM3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode(String userName, String clearTextPassword) throws SecurityException {
        String algorithm = this.getAlgorithm();
        String passwordValue = null;
        if (SM3.equals(algorithm)) {
            byte[] bytes;
            byte[] value = new byte[32];
            try {
                bytes = (userName + clearTextPassword).getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new SecurityException(e);
            }
            SM3Digest e = this.sm3Digester;
            synchronized (e) {
                this.sm3Digester.update(bytes, 0, bytes.length);
                this.sm3Digester.doFinal(value, 0);
            }
            passwordValue = "$SM3$" + new String(Base64.encodeBase64(value));
        } else {
            byte[] value;
            byte[] pb = clearTextPassword.getBytes();
            byte[] ub = userName.getBytes();
            MessageDigest messageDigest = this.digester;
            synchronized (messageDigest) {
                this.digester.reset();
                value = this.digester.digest(pb);
                this.digester.update(ub);
                value = this.digester.digest(value);
            }
            passwordValue = new String(Base64.encodeBase64(value));
        }
        return passwordValue;
    }

    public static String decrypt(String cryptData, String seed) throws Exception {
        if (seed == null || "".equals(seed)) {
            return cryptData;
        }
        Exception e = null;
        for (int i = 0; i < 5; ++i) {
            try {
                return MessageEncoder._decrypt(cryptData, seed);
            }
            catch (Exception ex) {
                e = ex;
                continue;
            }
        }
        throw new Exception(e);
    }

    private static String _decrypt(String cryptData, String seed) throws Exception {
        return (String)invocableEngine.invokeFunction("decrypt", cryptData, seed);
    }

    public static void initScriptEngine(File cryptoJSFile) throws IOException, ScriptException {
        if (invocableEngine == null) {
            ScriptEngineManager sem = new ScriptEngineManager();
            ScriptEngine se = sem.getEngineByName("javascript");
            invocableEngine = (Invocable)((Object)se);
            FileReader reader = new FileReader(cryptoJSFile);
            se.eval(reader);
            ((Reader)reader).close();
            se.eval("function decrypt(a,b){var v=CryptoJS.DES.decrypt(a,b);return ''+CryptoJS.enc.Utf8.stringify(v);}");
        }
    }
}

