/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.rate;

import com.google.common.util.concurrent.RateLimiter;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class SeeyonRateLimiter {
    private static final Map<String, Map<String, RateLimit>> rateLimitMap = new ConcurrentHashMap<String, Map<String, RateLimit>>();
    private static Set<String> limitPathSet = new TreeSet<String>();
    private static int permits = 1000;
    private static RateLimiter rateLimiter;

    public static void initRateLimiter(int procNumPreSecond) {
        if (rateLimiter == null) {
            permits = procNumPreSecond <= 0 ? permits : procNumPreSecond;
            rateLimiter = RateLimiter.create((double)permits);
        }
    }

    public static boolean acquire(RateLimit limit) {
        if (limit != null) {
            return rateLimiter.tryAcquire(limit.getWeight(), limit.getTimeout(), TimeUnit.MILLISECONDS);
        }
        return true;
    }

    public static boolean isLimitValid() {
        return rateLimiter != null;
    }

    public static Map<String, RateLimit> getLimitMap(String uri) {
        return rateLimitMap.get(uri);
    }

    public static void addRateLimit(String uri, RateLimit limit) {
        if (limit.isValid()) {
            Map<String, RateLimit> limitMap = rateLimitMap.get(uri);
            if (limitMap == null) {
                limitMap = new ConcurrentHashMap<String, RateLimit>();
                rateLimitMap.put(uri, limitMap);
                if ("rest".equals(limit.getRequestType())) {
                    limitPathSet.add(uri);
                }
            }
            limitMap.put(limit.getUrl(), limit);
        }
    }

    public static String getOptimumMatchLimitPath(String uri) {
        String path = null;
        for (String limit : limitPathSet) {
            if (!uri.startsWith(limit)) continue;
            path = limit;
        }
        return path;
    }

    public static int getPermits() {
        return permits;
    }

    public static class RateLimit {
        private final String DEFAULT_HINT_KEY = "common.rate.limit.hint.default";
        private String url;
        private Map<String, String> paraMap;
        private int weight;
        private boolean valid;
        private long timeout = 200L;
        private String toUrl;
        private String hint;
        private String requestType;
        private String code;

        public RateLimit(String url, int weight) {
            this.url = url;
            this.weight = weight;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public void addParameter(String name, String value) {
            if (this.paraMap == null) {
                this.paraMap = new ConcurrentHashMap<String, String>();
            }
            this.paraMap.put(name, value);
        }

        public String getToUrl() {
            return this.toUrl;
        }

        public void setToUrl(String toUrl) {
            this.toUrl = toUrl;
        }

        public String getHintInfo() {
            String hintInfo = ResourceUtil.getString(this.hint);
            if (hintInfo.equals(this.hint)) {
                hintInfo = ResourceUtil.getString("common.rate.limit.hint.default");
            }
            return hintInfo;
        }

        public void setHint(String hint) {
            this.hint = StringUtils.isEmpty((CharSequence)hint) ? "common.rate.limit.hint.default" : hint;
        }

        public Map<String, String> getParamMap() {
            return this.paraMap;
        }

        public void setRequestType(String requestType) {
            this.requestType = requestType;
        }

        public String getRequestType() {
            return this.requestType;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }
}

