/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.quartz;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.quartz.MutiQuartzJobNameException;
import com.seeyon.ctp.common.quartz.NoSuchQuartzJobBeanException;
import com.seeyon.ctp.common.quartz.QuartzJob;
import com.seeyon.ctp.common.quartz.QuartzJobProxy;
import com.seeyon.ctp.common.quartz.QuartzListener;
import com.seeyon.ctp.datasource.CtpDynamicDataSource;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMSQLOperation;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class QuartzHolder {
    private static final Log log = CtpLogFactory.getLog(QuartzHolder.class);
    public static String instanceName;
    protected static final String QUARTZ_JOB_CLASS_NAME;

    public static boolean newQuartzJob(String jobName, Date runTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        return QuartzHolder.newQuartzJob(jobName, runTime, 0, 0L, jobBeanId, parameters);
    }

    public static boolean newQuartzJob(String groupName, String jobName, Date runTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        return QuartzHolder.newQuartzJob(groupName, jobName, runTime, 0, 0L, jobBeanId, parameters);
    }

    public static boolean newQuartzJob(String jobName, Date beginTime, long repeatInterval, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        return QuartzHolder.newQuartzJob(jobName, beginTime, -1, repeatInterval, jobBeanId, parameters);
    }

    public static boolean newQuartzJob(String jobName, Date beginTime, int repeatCount, long repeatInterval, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        return QuartzHolder.newQuartzJob(null, jobName, beginTime, repeatCount, repeatInterval, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerDay(String groupName, String jobName, Date beginTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        return QuartzHolder.newQuartzJobPerDay(groupName, jobName, beginTime, null, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerDay(String groupName, String jobName, Date beginTime, Date endTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beginTime);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hourOfDay = gc.get(11);
        String cronExpression = second + " " + minute + " " + hourOfDay + " * * ?";
        return QuartzHolder.newCronQuartzJob(groupName, jobName, cronExpression, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerWeek(String groupName, String jobName, Date beginTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        Date endTime = null;
        return QuartzHolder.newQuartzJobPerWeek(groupName, jobName, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerWeek(String groupName, String jobName, Date beginTime, Date endTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beginTime);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hourOfDay = gc.get(11);
        int dayOfWeek = gc.get(7);
        String cronExpression = second + " " + minute + " " + hourOfDay + " ? * " + dayOfWeek;
        return QuartzHolder.newCronQuartzJob(groupName, jobName, cronExpression, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerMonth(String groupName, String jobName, Date beginTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        Date endTime = null;
        return QuartzHolder.newQuartzJobPerMonth(groupName, jobName, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerMonth(String groupName, String jobName, Date beginTime, Date endTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beginTime);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hourOfDay = gc.get(11);
        int dayOfMonth = gc.get(5);
        String cronExpression = second + " " + minute + " " + hourOfDay + " " + dayOfMonth + " * ?";
        return QuartzHolder.newCronQuartzJob(groupName, jobName, cronExpression, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobEndOfMonth(String groupName, String jobName, Date beginTime, Date endTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beginTime);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hourOfDay = gc.get(11);
        String cronExpression = second + " " + minute + " " + hourOfDay + " L * ?";
        return QuartzHolder.newCronQuartzJob(groupName, jobName, cronExpression, beginTime, endTime, jobBeanId, parameters);
    }

    private static boolean newQuartzJobEndOfMonth(String groupName, String jobName, Date beginTime, Date endTime, int days, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        if (days < 1 || days > 25) {
            log.warn((Object)("\u5012\u6570\u7b2c\u51e0\u5929\u7684\u53c2\u6570\u4f20\u9012\u4e0d\u5408\u6cd5\uff08\u53d6\u503c\u8303\u56f4\uff1a[1-25]\uff09,\u5f53\u524d\u4f20\u5165\u7684\u503c\u4e3a\uff1a" + days + "\uff0c\u7cfb\u7edf\u81ea\u52a8\u5c06\u8be5\u53c2\u6570\u8bbe\u7f6e\u4e3a\uff1a1"));
            days = 1;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beginTime);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hourOfDay = gc.get(11);
        String cronExpression = second + " " + minute + " " + hourOfDay + " " + days + "L * ?";
        return QuartzHolder.newCronQuartzJob(groupName, jobName, cronExpression, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerSeason(String groupName, String jobName, Date beginTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        Date endTime = null;
        return QuartzHolder.newQuartzJobPerSeason(groupName, jobName, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerSeason(String groupName, String jobName, Date beginTime, Date endTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beginTime);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hourOfDay = gc.get(11);
        int dayOfMonth = gc.get(5);
        int month = gc.get(2) + 1;
        int start = month % 3;
        start = start == 0 ? 3 : start;
        String cronExpression = second + " " + minute + " " + hourOfDay + " " + dayOfMonth + " " + start + "/3 ?";
        return QuartzHolder.newCronQuartzJob(groupName, jobName, cronExpression, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerHalfyear(String groupName, String jobName, Date beginTime, Date endTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beginTime);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hourOfDay = gc.get(11);
        int dayOfMonth = gc.get(5);
        int month = gc.get(2) + 1;
        int start = month % 6;
        start = start == 0 ? 6 : start;
        String cronExpression = second + " " + minute + " " + hourOfDay + " " + dayOfMonth + " " + start + "/6 ?";
        return QuartzHolder.newCronQuartzJob(groupName, jobName, cronExpression, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobEndOfHalfyear(String groupName, String jobName, Date beginTime, Date endTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beginTime);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hourOfDay = gc.get(11);
        String cronExpression = second + " " + minute + " " + hourOfDay + " L 6,12 ?";
        return QuartzHolder.newCronQuartzJob(groupName, jobName, cronExpression, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobEndOfSeason(String groupName, String jobName, Date beginTime, Date endTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beginTime);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hourOfDay = gc.get(11);
        String cronExpression = second + " " + minute + " " + hourOfDay + " L 3,6,9,12 ?";
        return QuartzHolder.newCronQuartzJob(groupName, jobName, cronExpression, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerYear(String groupName, String jobName, Date beginTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        Date endTime = null;
        return QuartzHolder.newQuartzJobPerYear(groupName, jobName, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newQuartzJobPerYear(String groupName, String jobName, Date beginTime, Date endTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(beginTime);
        int second = gc.get(13);
        int minute = gc.get(12);
        int hourOfDay = gc.get(11);
        int dayOfMonth = gc.get(5);
        int month = gc.get(2) + 1;
        String cronExpression = second + " " + minute + " " + hourOfDay + " " + dayOfMonth + " " + month + " ? *";
        return QuartzHolder.newCronQuartzJob(groupName, jobName, cronExpression, beginTime, endTime, jobBeanId, parameters);
    }

    public static boolean newCronQuartzJob(String groupName, String jobName, String cronExpression, Date beginTime, Date endTime, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        Scheduler sched = null;
        try {
            sched = QuartzListener.getScheduler();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(jobName, groupName).forJob(jobName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
        if (endTime != null) {
            triggerBuilder.endAt(endTime);
        }
        if (beginTime != null) {
            Date now = new Date();
            triggerBuilder.startAt(now.after(beginTime) ? now : beginTime);
        }
        Trigger trigger = triggerBuilder.build();
        return QuartzHolder.newQuartzJob(sched, jobName, groupName, trigger, jobBeanId, parameters);
    }

    public static boolean newQuartzJob(String groupName, String jobName, Date beginTime, int repeatCount, long repeatInterval, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        return QuartzHolder.newQuartzJob(groupName, jobName, beginTime, null, repeatCount, repeatInterval, jobBeanId, parameters);
    }

    public static boolean newQuartzJob(String groupName, String jobName, Date beginTime, Date endTime, int repeatCount, long repeatInterval, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        Scheduler sched = null;
        try {
            sched = QuartzListener.getScheduler();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
        SimpleTriggerImpl trigger = new SimpleTriggerImpl();
        trigger.setName(jobName);
        trigger.setGroup(groupName);
        Date now = new Date();
        if (beginTime != null) {
            trigger.setStartTime(now.after(beginTime) ? now : beginTime);
        }
        if (endTime != null) {
            trigger.setEndTime(endTime);
        }
        trigger.setRepeatCount(repeatCount);
        trigger.setRepeatInterval(repeatInterval);
        trigger.setMisfireInstruction(1);
        return QuartzHolder.newQuartzJob(sched, jobName, groupName, (Trigger)trigger, jobBeanId, parameters);
    }

    private static boolean newQuartzJob(Scheduler sched, String jobName, String groupName, Trigger trigger, String jobBeanId, Map<String, String> parameters) throws MutiQuartzJobNameException, NoSuchQuartzJobBeanException {
        Object quartzJob = null;
        try {
            quartzJob = AppContext.getBean(jobBeanId);
        }
        catch (Throwable e) {
            log.error((Object)"", e);
            return false;
        }
        if (quartzJob == null || !(quartzJob instanceof QuartzJob)) {
            throw new NoSuchQuartzJobBeanException(jobBeanId);
        }
        JobDataMap datamap = new JobDataMap();
        datamap.put(QUARTZ_JOB_CLASS_NAME, jobBeanId);
        datamap.put("_JobName", jobName);
        if (parameters != null && !parameters.isEmpty()) {
            Set<Map.Entry<String, String>> enities = parameters.entrySet();
            for (Map.Entry<String, String> entry : enities) {
                datamap.put(entry.getKey(), entry.getValue());
            }
        }
        JobDetail job = JobBuilder.newJob(QuartzJobProxy.class).withIdentity(jobName, groupName).setJobData(datamap).build();
        try {
            sched.scheduleJob(job, trigger);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
    }

    public static boolean updateQuartzJob(String groupName, String jobName, String jobBeanId, Map<String, String> parameters) throws NoSuchQuartzJobBeanException {
        Scheduler sched;
        try {
            sched = QuartzListener.getScheduler();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
        if (sched == null) {
            log.error((Object)"Scheduler is null");
            return false;
        }
        Object quartzJob = null;
        try {
            quartzJob = AppContext.getBean(jobBeanId);
        }
        catch (Throwable e) {
            log.error((Object)"", e);
            return false;
        }
        if (quartzJob == null || !(quartzJob instanceof QuartzJob)) {
            throw new NoSuchQuartzJobBeanException(jobBeanId);
        }
        JobDataMap datamap = new JobDataMap();
        datamap.put(QUARTZ_JOB_CLASS_NAME, jobBeanId);
        datamap.put("_JobName", jobName);
        if (parameters != null && !parameters.isEmpty()) {
            Set<Map.Entry<String, String>> enities = parameters.entrySet();
            for (Map.Entry<String, String> entry : enities) {
                datamap.put(entry.getKey(), entry.getValue());
            }
        }
        JobDetail job = null;
        try {
            job = sched.getJobDetail(JobKey.jobKey((String)jobName, (String)groupName));
        }
        catch (SchedulerException e) {
            log.error((Object)("getJobDetail[" + groupName + "." + jobName + "] occur error"), (Throwable)e);
            return false;
        }
        if (job == null) {
            log.error((Object)("jobDetail[" + groupName + "." + jobName + "] not exist"));
            return false;
        }
        try {
            sched.addJob(job, true, true);
        }
        catch (SchedulerException e) {
            log.error((Object)("addOrUpdateJob [" + groupName + "." + jobName + "] occur error"), (Throwable)e);
            return false;
        }
        return false;
    }

    public static boolean deleteQuartzJob(String jobName) {
        try {
            Scheduler sched = QuartzListener.getScheduler();
            sched.deleteJob(JobKey.jobKey((String)jobName));
            return true;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public static boolean deleteQuartzJobByGroup(String groupName) {
        if (Strings.isBlank(groupName)) {
            throw new IllegalArgumentException("groupName is null");
        }
        if ("DEFAULT".equalsIgnoreCase(groupName)) {
            throw new IllegalArgumentException("groupName is DEFAULT");
        }
        try {
            Scheduler sched = QuartzListener.getScheduler();
            Set jobKeys = sched.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            for (JobKey jobKey : jobKeys) {
                sched.deleteJob(jobKey);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public static boolean deleteQuartzJobByGroupAndJobName(String groupName, String name) {
        if (Strings.isBlank(groupName)) {
            throw new IllegalArgumentException("groupName is null");
        }
        if ("DEFAULT".equalsIgnoreCase(groupName)) {
            throw new IllegalArgumentException("groupName is DEFAULT");
        }
        try {
            Scheduler sched = QuartzListener.getScheduler();
            sched.deleteJob(JobKey.jobKey((String)name, (String)groupName));
            return true;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public static boolean hasQuartzJob(String jobName) {
        return QuartzHolder.hasQuartzJob(null, jobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasQuartzJob(String groupName, String jobName) {
        if (instanceName == null) {
            QuartzHolder.loadInstanceName();
        }
        JDBCAgent agent = null;
        try {
            CtpDynamicDataSource.setDataSourceKey(DataSourceName.BASE.getSource());
            agent = new JDBCAgent(true);
            String sql = "SELECT JOB_NAME FROM JK_JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ? AND SCHED_NAME = ?";
            ArrayList<String> params = new ArrayList<String>();
            params.add(jobName);
            params.add(groupName == null ? "DEFAULT" : groupName);
            params.add(instanceName);
            JDBCAgent.putTrackTableInfo(JMSQLOperation.Select, "JK_JOB_DETAILS");
            agent.execute(sql, params);
            boolean bl = !CollectionUtils.isEmpty((Collection)agent.resultSetToList());
            return bl;
        }
        catch (Throwable e) {
            log.error((Object)e.getLocalizedMessage(), e);
        }
        finally {
            agent.close();
            CtpDynamicDataSource.clearDataSourceKey();
        }
        return false;
    }

    private static synchronized void loadInstanceName() {
        if (instanceName == null) {
            Scheduler sched = null;
            try {
                sched = QuartzListener.getScheduler();
                instanceName = sched.getSchedulerName();
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    static {
        QUARTZ_JOB_CLASS_NAME = QuartzHolder.class.getName() + ".QuartzJobClassName";
    }
}

