/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.po;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.BasePO;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class DataContainer
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -579838255747924295L;
    private static final Log log = CtpLogFactory.getLog(DataContainer.class);
    private static final String STRING_SEPARATOR = "\"";
    private static final String JSON_OBJECT_START = "{";
    private static final String JSON_OBJECT_END = "}";
    private static final String JSON_ARRAY_START = "[";
    private static final String JSON_ARRAY_END = "]";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String ATTRIBUTE_SEPARATOR = ",";
    private static final String ENTER_BREAK = "";
    private static final int LIST_CONVERT_LIMIT = 500000;
    private static final int CONVERT_JSON_BUFFER = 10000;
    private Map<String, Object> dataMap = new LinkedHashMap<String, Object>();

    public Object remove(String key) {
        return this.dataMap.remove(key);
    }

    public void add(String key, int value) {
        this.addDataItem(key, value);
    }

    public void add(String key, long value) {
        this.addDataItem(key, value);
    }

    public void add(String key, short value) {
        this.addDataItem(key, value);
    }

    public void add(String key, byte value) {
        this.addDataItem(key, value);
    }

    public void add(String key, float value) {
        this.addDataItem(key, Float.valueOf(value));
    }

    public void add(String key, double value) {
        this.addDataItem(key, value);
    }

    public void add(String key, boolean value) {
        this.addDataItem(key, value);
    }

    public void add(String key, char value) {
        this.addDataItem(key, Character.valueOf(value));
    }

    public void add(String key, String value) {
        this.addDataItem(key, value);
    }

    public void add(String key, Date value) {
        this.addDataItem(key, value);
    }

    public void add(String key, DataContainer value) {
        this.addDataItem(key, value);
    }

    public void add(String key, BasePO value) {
        this.addDataItem(key, value);
    }

    public void add(String key, Object value) {
        this.addDataItem(key, value);
    }

    public void add(String key, List<? extends Object> value) {
        this.addDataItem(key, value);
    }

    public void add(String key, String[] value) {
        this.addDataItem(key, value);
    }

    public void add(String key, int[] value) {
        this.addDataItem(key, value);
    }

    private void addDataItem(String key, Object value) {
        this.dataMap.put(key, value);
    }

    public String getJson() {
        return this.getJson(true, 500000);
    }

    public String getJson(int size) {
        int tempSize = size;
        if (tempSize < 0) {
            tempSize = 500000;
        }
        return this.getJson(true, tempSize);
    }

    private String getJson(boolean nestedFlag, int size) {
        StringBuilder tempBuffer = new StringBuilder(10000);
        tempBuffer.append(JSON_OBJECT_START);
        Set<Map.Entry<String, Object>> entrySet = this.dataMap.entrySet();
        if (entrySet != null && entrySet.size() > 0) {
            for (Map.Entry<String, Object> entry : entrySet) {
                String key = STRING_SEPARATOR + entry.getKey() + STRING_SEPARATOR;
                Object value = entry.getValue();
                String valueString = "null";
                if (value != null) {
                    if (value instanceof String) {
                        valueString = STRING_SEPARATOR + Strings.escapeJson((String)value) + STRING_SEPARATOR;
                    } else if (value instanceof DataContainer) {
                        if (nestedFlag) {
                            DataContainer container = (DataContainer)value;
                            valueString = container.getJson(false, size);
                        } else {
                            valueString = "\"DataContainer\u7c7b\u578b\u7684\u5bf9\u8c61\u53ea\u652f\u6301\u4e00\u5c42\u5d4c\u5957\uff01 \"";
                        }
                    } else {
                        valueString = value instanceof Date ? STRING_SEPARATOR + DateUtil.getStandard19DateAndTime((Date)value) + STRING_SEPARATOR : (value instanceof BasePO ? ((BasePO)value).toJSON() : (value instanceof String[] ? DataContainer.convertArray((String[])value, size) : (value instanceof int[] ? DataContainer.convertArray((int[])value, size) : (value instanceof List ? DataContainer.convertList((List)value, size) : (value instanceof Character ? STRING_SEPARATOR + Strings.escapeJson(String.valueOf(value)) + STRING_SEPARATOR : value.toString())))));
                    }
                }
                tempBuffer.append(key + KEY_VALUE_SEPARATOR + valueString + ATTRIBUTE_SEPARATOR + ENTER_BREAK);
            }
        }
        tempBuffer.append(JSON_OBJECT_END);
        int start = tempBuffer.lastIndexOf(ATTRIBUTE_SEPARATOR);
        if (start != -1) {
            int end = start + ATTRIBUTE_SEPARATOR.length();
            tempBuffer.replace(start, end, ENTER_BREAK);
        }
        return tempBuffer.toString();
    }

    @Override
    public int size() {
        return this.dataMap.size();
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.dataMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.dataMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.dataMap.entrySet();
    }

    @Override
    public Object get(Object key) {
        Object result = null;
        result = "json".equals(key) ? this.getJson() : this.dataMap.get(key);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.dataMap.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        this.addDataItem(key, value);
        return this.dataMap;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this.dataMap.putAll(t);
    }

    @Override
    public Object remove(Object key) {
        return this.dataMap.remove(key);
    }

    @Override
    public Collection<Object> values() {
        return this.dataMap.values();
    }

    public static String convertList(List<? extends Object> list) {
        return DataContainer.convertList(list, 500000);
    }

    public static String convertList(List<? extends Object> list, int size) {
        StringBuilder listBuffer = new StringBuilder();
        listBuffer.append(JSON_ARRAY_START);
        if (list != null && list.size() > 0) {
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                Object object = list.get(i);
                if (i > size) break;
                try {
                    if (object instanceof BasePO) {
                        BasePO bean = (BasePO)object;
                        listBuffer.append(ENTER_BREAK + bean.toJSON() + ATTRIBUTE_SEPARATOR + ENTER_BREAK);
                        continue;
                    }
                    if (object instanceof DataContainer) {
                        DataContainer container = (DataContainer)object;
                        listBuffer.append(ENTER_BREAK + container.getJson() + ATTRIBUTE_SEPARATOR + ENTER_BREAK);
                        continue;
                    }
                    if (object instanceof String[]) {
                        String[] array = (String[])object;
                        listBuffer.append(ENTER_BREAK + DataContainer.convertArray(array) + ATTRIBUTE_SEPARATOR + ENTER_BREAK);
                        continue;
                    }
                    if (!(object instanceof String) && !(object instanceof Long)) continue;
                    listBuffer.append(STRING_SEPARATOR + Strings.escapeJson(object.toString()) + STRING_SEPARATOR + ATTRIBUTE_SEPARATOR);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"\u8f6c\u6362json\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        listBuffer.append(JSON_ARRAY_END);
        DataContainer.fromatBuffer(listBuffer);
        return listBuffer.toString();
    }

    public static String convertArray(String[] array) {
        return DataContainer.convertArray(array, 500000);
    }

    public static String convertArray(String[] array, int size) {
        StringBuilder listBuffer = new StringBuilder();
        listBuffer.append(JSON_ARRAY_START);
        if (array != null && array.length > 0) {
            int len = array.length;
            for (int i = 0; i < len && i <= size; ++i) {
                String tempString = array[i];
                try {
                    listBuffer.append(tempString == null ? null : STRING_SEPARATOR + Strings.escapeJson(tempString) + STRING_SEPARATOR + ATTRIBUTE_SEPARATOR);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"\u8f6c\u6362json\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        listBuffer.append(JSON_ARRAY_END);
        DataContainer.fromatBuffer(listBuffer);
        return listBuffer.toString();
    }

    public static String convertArray(int[] array) {
        return DataContainer.convertArray(array, 500000);
    }

    public static String convertArray(int[] array, int size) {
        StringBuilder listBuffer = new StringBuilder();
        listBuffer.append(JSON_ARRAY_START);
        if (array != null && array.length > 0) {
            int len = array.length;
            for (int i = 0; i < len && i <= size; ++i) {
                int tempInt = array[i];
                try {
                    listBuffer.append(tempInt + ATTRIBUTE_SEPARATOR);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"\u8f6c\u6362json\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        listBuffer.append(JSON_ARRAY_END);
        DataContainer.fromatBuffer(listBuffer);
        return listBuffer.toString();
    }

    public static String createArrayByJsonObject(String[] array) {
        return DataContainer.createArrayByJsonObject(array, 500000);
    }

    public static String createArrayByJsonObject(String[] array, int size) {
        StringBuilder listBuffer = new StringBuilder();
        listBuffer.append(JSON_ARRAY_START);
        if (array != null && array.length > 0) {
            int len = array.length;
            for (int i = 0; i < len && i <= size; ++i) {
                String tempJson = array[i];
                try {
                    listBuffer.append(ENTER_BREAK + tempJson + ATTRIBUTE_SEPARATOR + ENTER_BREAK);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"\u8f6c\u6362json\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        listBuffer.append(JSON_ARRAY_END);
        DataContainer.fromatBuffer(listBuffer);
        return listBuffer.toString();
    }

    public static Map<String, Object> parseJsonToMap(String jsonString) {
        Map result = null;
        if (jsonString != null && !ENTER_BREAK.equals(jsonString.trim()) && !"undefined".equals(jsonString)) {
            try {
                result = JSONUtil.parseJSONString(jsonString, Map.class);
            }
            catch (Exception e) {
                log.error((Object)("DataContainer\u89e3\u6790json\u5f02\u5e38\uff0cjson=" + jsonString), (Throwable)e);
            }
        }
        return result;
    }

    private static StringBuilder fromatBuffer(StringBuilder buffer) {
        int start = buffer.lastIndexOf(ATTRIBUTE_SEPARATOR);
        if (start != -1) {
            int end = start + ATTRIBUTE_SEPARATOR.length();
            buffer.replace(start, end, ENTER_BREAK);
        }
        return buffer;
    }
}

