/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.parser;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.parser.IFileParser;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.htmlparser.beans.StringBean;
import org.htmlparser.tags.TitleTag;
import org.htmlparser.util.EncodingChangeException;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public class HTMLFileParser
extends StringBean
implements IFileParser {
    private static final Log log = CtpLogFactory.getLog(HTMLFileParser.class);
    private String title;
    private Hashtable metadata;

    public HTMLFileParser() {
    }

    public HTMLFileParser(File file) {
        this.setFile(file);
    }

    public void setString(String htmlContent) {
        this.metadata = new Hashtable();
        this.setCollapse(true);
        try {
            this.mParser.setEncoding("gb2312");
            this.updateStrings(htmlContent);
            this.extractStrings();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void setFile(File file) {
        this.metadata = new Hashtable();
        this.setCollapse(true);
        try {
            this.mParser.setEncoding("gb2312");
            this.setURL(file.toURL().toString());
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void setStr(String htmlStr) {
        this.metadata = new Hashtable();
        this.setCollapse(true);
        try {
            this.mParser.setEncoding("gb2312");
            this.mParser.setInputHTML(htmlStr);
            this.setTheStr();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void setTheStr() {
        try {
            try {
                this.mParser.visitAllNodesWith((NodeVisitor)this);
                this.updateStrings(this.mBuffer.toString());
            }
            finally {
                this.mBuffer = new StringBuffer(4096);
            }
        }
        catch (EncodingChangeException ece) {
            this.mIsPre = false;
            this.mIsScript = false;
            this.mIsStyle = false;
            try {
                this.mParser.reset();
                this.mBuffer = new StringBuffer(4096);
                this.mCollapseState = 0;
                this.mParser.visitAllNodesWith((NodeVisitor)this);
                this.updateStrings(this.mBuffer.toString());
            }
            catch (ParserException pe) {
                this.updateStrings(pe.toString());
            }
            finally {
                this.mBuffer = new StringBuffer(4096);
            }
        }
        catch (ParserException pe) {
            this.updateStrings(pe.toString());
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContentString() {
        return this.getStrings();
    }

    @Override
    public Reader getContentReader() {
        String s = this.getContentString();
        StringReader reader = null;
        if (s != null) {
            reader = new StringReader(s);
        }
        return reader;
    }

    @Override
    public String getMetadata(String metadataname) {
        return (String)this.metadata.get(metadataname);
    }

    public void visitTitleTag(TitleTag titleTag) {
        this.title = titleTag.getTitle();
    }
}

