/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.office.trans.manager;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemInitializer;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.event.AttachmentSaveEvent;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.office.rmi.OfficeTransService;
import com.seeyon.ctp.common.office.trans.manager.OfficeTransManager;
import com.seeyon.ctp.common.office.trans.manager.SeeyonOfficeTransManagerImpl;
import com.seeyon.ctp.common.office.trans.manager.YongZhongOfficeTransManagerImpl;
import com.seeyon.ctp.common.office.trans.util.OfficeTransHelper;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.common.timer.TimerHolder;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.RMIUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.ListenEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ProcessInDataSource(name=DataSourceName.BASE)
public class OfficeTransManagerImpl
implements OfficeTransManager,
SystemInitializer {
    private static final String ERR_MSG_GENERATE_ERROR = "\u8f6c\u6362\u6587\u4ef6\u51fa\u9519\u3002";
    private static final String ERR_MSG_OFFICE_IS_NOT_EXIST = "\u8f6c\u6362\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a";
    private static final Log log = LogFactory.getLog(OfficeTransManagerImpl.class);
    private String transType;
    private SeeyonOfficeTransManagerImpl seeyonOfficeTransManager = null;
    private YongZhongOfficeTransManagerImpl yongZhongOfficeTransManager = null;
    private FileManager fileManager;
    private String outputPath;
    private int retainDay = 30;
    private static String host = "127.0.0.1";
    private static int port = 1097;
    private long fileMaxSize = 0x1E00000L;
    private File outputTempDir;
    private final List<Long[]> firstFileQueue = new ArrayList<Long[]>();
    private final List<Long[]> lastFileQueue = new ArrayList<Long[]>();
    private final int queueMaxNumber = 10000;
    private Object lock = new Object();
    private GenerateThread generateThread;

    public String getTransType() {
        return this.transType;
    }

    public void setTransType(String transType) {
        this.transType = transType;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setRetainDay(int retainDay) {
        this.retainDay = retainDay;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setHost(String host) {
        OfficeTransManagerImpl.host = host;
    }

    public void setPort(int port) {
        OfficeTransManagerImpl.port = port;
    }

    public void setFileMaxSize(long fileMaxSize) {
        this.fileMaxSize = fileMaxSize;
    }

    public void init() {
    }

    @Override
    public void destroy() {
        this.generateThread.stopThread();
    }

    @Override
    public String document2Pdf(long fileId, long v3xFileCreateDate) throws BusinessException {
        try {
            if ("yongzhong".equals(this.getOfficeTransType())) {
                if (this.yongZhongOfficeTransManager != null) {
                    return this.yongZhongOfficeTransManager.document2Pdf(fileId, v3xFileCreateDate);
                }
                throw new BusinessException(ResourceUtil.getString("system.officeTrans.msg.officeTransManager.null"));
            }
            throw new BusinessException(ResourceUtil.getString("system.officeTrans.msg.notSupport.convert.pdf"));
        }
        catch (BusinessException e) {
            log.error((Object)"document2Pdf BusinessException ", (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"document2Pdf Exception ", (Throwable)e);
            throw new BusinessException(ResourceUtil.getString("system.officeTrans.exception.document2Pdf"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(long fileId, Date v3xFileCreateDate, boolean isImmediately) {
        Long[] o = new Long[]{fileId, v3xFileCreateDate.getTime()};
        Object object = this.lock;
        synchronized (object) {
            if (isImmediately) {
                if (this.firstFileQueue.size() < this.queueMaxNumber) {
                    this.firstFileQueue.add(o);
                }
            } else if (this.lastFileQueue.size() < this.queueMaxNumber) {
                this.lastFileQueue.add(o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getNext() {
        if (this.firstFileQueue.isEmpty() && this.lastFileQueue.isEmpty()) {
            return null;
        }
        ArrayList<Long[]> f = null;
        ArrayList<Long[]> l = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.firstFileQueue.isEmpty()) {
                f = new ArrayList<Long[]>(this.firstFileQueue);
                this.firstFileQueue.clear();
            }
            if (!this.lastFileQueue.isEmpty()) {
                l = new ArrayList<Long[]>(this.lastFileQueue);
                this.lastFileQueue.clear();
            }
        }
        return new Object[]{f, l};
    }

    private final void doGenerate(List<Long[]> f, List<Long[]> l) throws BusinessException {
        try {
            if ("yongzhong".equals(this.getOfficeTransType()) && this.yongZhongOfficeTransManager != null) {
                this.yongZhongOfficeTransManager.doGenerate(f, l);
            }
            if ("seeyon".equals(this.getOfficeTransType()) && this.seeyonOfficeTransManager != null) {
                if (f != null && !f.isEmpty()) {
                    for (Long[] o : f) {
                        this.seeyonOfficeTransManager.doTransToServer(o[0], o[1]);
                    }
                }
                if (l != null && !l.isEmpty()) {
                    for (Long[] o : l) {
                        this.seeyonOfficeTransManager.doTransToServer(o[0], o[1]);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)ERR_MSG_GENERATE_ERROR, e);
        }
    }

    @Override
    public void visit(long id) {
    }

    @Override
    public void clean() {
        Date date = Datetimes.addDate(new Date(), -this.retainDay);
        long time = date.getTime();
        File outputDir = new File(this.outputPath);
        File[] dayDirs = outputDir.listFiles();
        if (dayDirs != null) {
            for (File dayDir : dayDirs) {
                try {
                    File[] attachmentFiles;
                    if (!dayDir.isDirectory() || dayDir.getName().length() != 8 || (attachmentFiles = dayDir.listFiles()) == null) continue;
                    for (File attachment : attachmentFiles) {
                        try {
                            long modifiedTime = attachment.lastModified();
                            if (modifiedTime >= time || !attachment.exists()) continue;
                            FileUtils.deleteDirectory((File)attachment);
                        }
                        catch (Throwable e) {
                            log.error((Object)e);
                        }
                    }
                    File[] attachmentFiles2 = dayDir.listFiles();
                    if (attachmentFiles2 != null && attachmentFiles2.length != 0 || !dayDir.exists()) continue;
                    FileUtils.deleteDirectory((File)dayDir);
                }
                catch (Throwable e) {
                    log.error((Object)e);
                }
            }
        }
        try {
            if (this.outputTempDir.exists()) {
                FileUtils.cleanDirectory((File)this.outputTempDir);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    @Override
    public void clean(long id, String date) {
        try {
            File file = new File(this.outputPath + File.separator + date + File.separator + id);
            if (file.exists()) {
                FileUtils.deleteDirectory((File)file);
            }
        }
        catch (Throwable e) {
            log.error((Object)"", e);
        }
    }

    @ListenEvent(event=AttachmentSaveEvent.class)
    public void onAttachmentSave(AttachmentSaveEvent event) {
        Attachment attachment = event.getAttachment();
        if (OfficeTransHelper.allowTrans(attachment) && OfficeTransHelper.isPreConvert()) {
            try {
                this.generate(attachment.getFileUrl(), attachment.getCreatedate(), true);
            }
            catch (Exception e) {
                log.error((Object)"\u9644\u4ef6\u4fdd\u5b58\u65f6\u751f\u6210HTML\u51fa\u9519\u3002", (Throwable)e);
            }
        }
    }

    @Override
    public String buildSourceDownloadUrl(long id) {
        StringBuilder url = new StringBuilder();
        try {
            V3XFile f = this.fileManager.getV3XFile(id);
            if (f != null) {
                url.append("/seeyon/fileUpload.do?method=download");
                url.append("&fileId=").append(id);
                url.append("&createDate=").append(Datetimes.formatDate(f.getCreateDate()));
                url.append("&viewMode=download");
                url.append("&filename=").append(Strings.escapeJavascript(f.getFilename()));
            }
        }
        catch (BusinessException e) {
            log.error((Object)e);
        }
        return url.toString();
    }

    @Override
    public boolean isExist(long id, String date) throws BusinessException {
        if ("yongzhong".equals(this.transType) && this.yongZhongOfficeTransManager != null) {
            return this.yongZhongOfficeTransManager.isExist(id, date);
        }
        if ("seeyon".equals(this.transType) && this.seeyonOfficeTransManager != null) {
            return this.seeyonOfficeTransManager.isExistForNewOfficeTrans(id, date);
        }
        return false;
    }

    @Override
    public String getOutputPath() {
        return this.outputPath;
    }

    @Override
    public long getFileMaxSize() {
        return this.fileMaxSize;
    }

    @Override
    public String getOfficeTransType() {
        return this.getTransType();
    }

    @Override
    public String getOfficeTransHost() {
        return host;
    }

    @Override
    public int getOfficeTransPort() {
        return port;
    }

    @Override
    public String getOfficeTransCacheFolder() {
        return this.outputPath;
    }

    @Override
    public File getOfficeTransOutputTempDir() {
        return this.outputTempDir;
    }

    @Override
    public void initialize() {
        Object yongZhongOfficeTransManagerObj;
        Object seeyonOfficeTransManagerObj = AppContext.getBean("seeyonOfficeTransManager");
        if (seeyonOfficeTransManagerObj != null) {
            this.seeyonOfficeTransManager = (SeeyonOfficeTransManagerImpl)seeyonOfficeTransManagerObj;
        }
        if ((yongZhongOfficeTransManagerObj = AppContext.getBean("yongZhongOfficeTransManager")) != null) {
            this.yongZhongOfficeTransManager = (YongZhongOfficeTransManagerImpl)yongZhongOfficeTransManagerObj;
        }
        this.outputTempDir = new File(this.outputPath + File.separator + "Temp");
        this.generateThread = new GenerateThread();
        this.generateThread.start();
        TimerHolder.newTimer(new Runnable(){

            @Override
            public void run() {
                OfficeTransManagerImpl.this.clean();
            }
        }, 1000L, 86400000L, true, "OfficeTransCleanTimer");
    }

    public static OfficeTransService getService() {
        OfficeTransService service;
        String serviceName = "ctpOfficeTransService";
        Class<OfficeTransService> serviceInterface = OfficeTransService.class;
        try {
            service = RMIUtil.getProxy(host, port, serviceName, serviceInterface);
        }
        catch (Throwable e) {
            String msg = "\u8bbf\u95ee\u6587\u4ef6\u8f6c\u6362\u670d\u52a1\u51fa\u9519\uff1a" + host + ":" + port + "/" + serviceName;
            log.error((Object)msg, e);
            return null;
        }
        return service;
    }

    class GenerateThread
    extends Thread {
        private boolean running = true;
        private long lastWorkTimestamp;

        GenerateThread() {
        }

        @Override
        public synchronized void start() {
            super.setName("OfficeTrans");
            super.start();
        }

        public void stopThread() {
            this.running = false;
            try {
                this.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Object[] o = OfficeTransManagerImpl.this.getNext();
                    if (o != null) {
                        OfficeTransManagerImpl.this.doGenerate((List)o[0], (List)o[1]);
                    }
                }
                catch (Throwable e) {
                    if (log.isDebugEnabled()) {
                        log.error((Object)"", e);
                    }
                    log.error((Object)e.getMessage());
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

