/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.office.trans;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.exceptions.InfrastructureException;
import com.seeyon.ctp.common.office.trans.manager.OfficeTransManager;
import com.seeyon.ctp.common.office.trans.manager.SeeyonOfficeTransManagerImpl;
import com.seeyon.ctp.common.office.trans.util.FileType;
import com.seeyon.ctp.common.office.trans.util.OfficeTransHelper;
import com.seeyon.ctp.common.web.GenericFilterProxy;
import com.seeyon.ctp.common.web.util.WebUtil;
import com.seeyon.ctp.services.security.ServiceManager;
import com.seeyon.ctp.util.Cookies;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.Strings;
import com.seeyon.v3x.system.manager.WaterMarkSettingManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OfficeTransFilterImpl
extends GenericFilterProxy {
    private static final long serialVersionUID = -8336186823166931012L;
    private static final Log log = LogFactory.getLog(OfficeTransFilterImpl.class);
    private OfficeTransManager officeTransManager;
    private WaterMarkSettingManager waterMarkSettingManager;
    private byte[] jsByteArray;
    private int provider;

    public WaterMarkSettingManager getWaterMarkSettingManager() {
        return this.waterMarkSettingManager;
    }

    public void setWaterMarkSettingManager(WaterMarkSettingManager waterMarkSettingManager) {
        this.waterMarkSettingManager = waterMarkSettingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OfficeTransFilterImpl() {
        ByteArrayOutputStream jsByteArrayOut;
        InputStream jsInputStream;
        block6: {
            this.jsByteArray = new byte[0];
            this.provider = 3;
            String jsPath = "removeOfficeReviewStyle.js";
            jsInputStream = null;
            jsByteArrayOut = new ByteArrayOutputStream();
            try {
                jsInputStream = this.getClass().getResourceAsStream(jsPath);
                if (jsInputStream != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n<script language=\"JavaScript\">\n");
                    int n = 0;
                    byte[] content = new byte[4096];
                    while ((n = jsInputStream.read(content)) != -1) {
                        jsByteArrayOut.write(content, 0, n);
                    }
                    sb.append(new String(jsByteArrayOut.toByteArray(), "UTF-8"));
                    sb.append("\n</script>\n");
                    this.jsByteArray = sb.toString().getBytes("ISO-8859-1");
                    break block6;
                }
                log.error((Object)("\u6ca1\u6709\u627e\u5230 " + jsPath));
            }
            catch (IOException e) {
                try {
                    log.error((Object)("\u8bfb\u53d6 " + jsPath + " \u65f6\u53d1\u751f\u9519\u8bef\uff1a"), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(jsInputStream);
                    IOUtils.closeQuietly((OutputStream)jsByteArrayOut);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)jsInputStream);
                IOUtils.closeQuietly((OutputStream)jsByteArrayOut);
            }
        }
        IOUtils.closeQuietly((InputStream)jsInputStream);
        IOUtils.closeQuietly((OutputStream)jsByteArrayOut);
    }

    private Object[] extractFileId(String uri) {
        int beginIndex = uri.lastIndexOf("/");
        int endIndex = uri.lastIndexOf(".html");
        long fileId = 0L;
        String date = null;
        if (endIndex > 0) {
            String sFileId = uri.substring(beginIndex + 1, endIndex);
            if (!Strings.isEmpty(sFileId)) {
                try {
                    fileId = Long.parseLong(sFileId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int prefix = "/seeyon/office/cache/".length();
            date = StringUtils.substring((String)uri, (int)prefix, (int)(prefix + 8));
        }
        return new Object[]{fileId, date};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean writeStaticContentToBrower(long fileId, String fileName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletOutputStream out;
        FileInputStream in;
        block20: {
            boolean isMobile;
            String srcFile = this.officeTransManager.getOutputPath() + "/" + fileName;
            File file = new File(srcFile);
            String fileN = file.getName();
            String fileType = fileN.substring(fileN.lastIndexOf(".") + 1);
            if ("css".equals(fileType)) {
                response.setContentType("text/css");
            } else if ("html".equals(fileType) || "htm".equals(fileType)) {
                response.setContentType("text/html");
            } else if ("svg".equals(fileType)) {
                response.setContentType("image/svg+xml");
            }
            String etag = String.valueOf(fileName.hashCode()) + "-" + file.lastModified();
            if (fileId != 0L) {
                this.officeTransManager.visit(fileId);
            }
            if (WebUtil.checkEtag(request, response, etag)) {
                // empty if block
            }
            WebUtil.writeETag(request, response, etag);
            String src = srcFile;
            User user = null;
            try {
                HttpSession session = request.getSession(false);
                user = (User)session.getAttribute("com.seeyon.current_user");
            }
            catch (InfrastructureException session) {
                // empty catch block
            }
            if (user != null) {
                AppContext.putThreadContext("SESSION_CONTEXT_USERINFO_KEY", user);
            }
            boolean bl = isMobile = user != null && ("phone".equals(Constants.login_sign.stringValueOf(user.getLoginSign())) || "wechat".equals(Constants.login_sign.stringValueOf(user.getLoginSign())));
            if (isMobile && !new File(src = srcFile.replace(".html", "_1.html")).exists()) {
                src = srcFile;
            }
            in = null;
            out = response.getOutputStream();
            try {
                Map<String, Object> waterMarkInfo;
                in = new FileInputStream(src);
                int n = 0;
                byte[] content = new byte[4096];
                while ((n = ((InputStream)in).read(content)) != -1) {
                    out.write(content, 0, n);
                }
                if (this.provider == 2) {
                    String fnl = fileName.toLowerCase();
                    if (fnl.endsWith(".html") || fnl.endsWith(".htm")) {
                        out.write(this.jsByteArray);
                    }
                    break block20;
                }
                String fnl = fileName.toLowerCase();
                if (!fnl.endsWith(".html") && !fnl.endsWith(".htm") || (waterMarkInfo = this.waterMarkSettingManager.waterMarkInfo("officePreview", isMobile, false)) == null || !Boolean.TRUE.equals(waterMarkInfo.get("show"))) break block20;
                String watermark = this.waterMarkSettingManager.createWaterMarkBase64Img();
                out.write(("<div class=\"mask\"></div><style>.mask{width:86%;height:92%;left:60px;top:60px;z-index:8000;position:fixed}\n  .mask{background-size:200px 100px;background-image:url(" + watermark + ")}html,body{-webkit-user-select: none;-moz-user-select: none;-ms-user-select: none;user-select: none;}</style>").getBytes("ISO-8859-1"));
            }
            catch (IOException n) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
            catch (Exception e) {
                block21: {
                    if ("ClientAbortException".equals(e.getClass().getSimpleName())) break block21;
                    log.error((Object)("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u4ef6:" + srcFile), (Throwable)e);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            IOUtils.closeQuietly((OutputStream)out);
                            throw throwable;
                        }
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean doFilter(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpServletRequest httpRequest = request;
        String uri = httpRequest.getRequestURI();
        WebUtil.setRequest(request);
        WebUtil.setResponse(response);
        String fileName = StringUtils.substringAfter((String)uri, (String)"/seeyon/office/cache/");
        if (fileName.contains("../")) {
            return false;
        }
        if (Strings.isBlank(fileName)) {
            return true;
        }
        HttpSession session = httpRequest.getSession();
        User user = (User)session.getAttribute("com.seeyon.current_user");
        if (user == null) {
            String token = request.getHeader("token");
            if (Strings.isEmpty(token)) {
                token = request.getParameter("token");
            }
            if (Strings.isEmpty(token)) {
                token = Cookies.get(request, "token");
            }
            if (Strings.isEmpty(token) || "null".equalsIgnoreCase(token)) return false;
            ServiceManager.getInstance();
            if (!ServiceManager.checkToken(token)) return false;
            ServiceManager.getInstance().initCurrentUser(request, token);
            session.setAttribute("com.seeyon.current_user", (Object)AppContext.getCurrentUser());
        }
        Object[] o = this.extractFileId(uri);
        long fileId = (Long)o[0];
        String dateStr = (String)o[1];
        String transType = this.officeTransManager.getOfficeTransType();
        if ("yongzhong".equals(transType) && (AppContext.hasPlugin("baseOfficeTrans") || AppContext.hasPlugin("yongzhongOfficeTrans"))) {
            String srcFile = this.officeTransManager.getOutputPath() + "/" + fileName;
            File file = new File(srcFile);
            boolean fileExist = false;
            fileExist = fileId != 0L ? this.officeTransManager.isExist(fileId, dateStr) : file.exists();
            if (!fileExist && srcFile.indexOf(37) > -1) {
                fileName = URLDecoder.decode(fileName, "UTF-8");
                file = new File(this.officeTransManager.getOutputPath() + "/" + fileName);
                fileExist = file.exists();
            }
            if (fileExist) {
                this.writeStaticContentToBrower(fileId, fileName, request, response);
            } else if (fileId != 0L) {
                Date fileCreateDate = Datetimes.parse(dateStr, "yyyyMMdd");
                this.officeTransManager.generate(fileId, fileCreateDate, true);
                this.redirect(response, "/seeyon/officeTrans.do?method=wait&fileId=" + fileId + "&fileCreateDate=" + Datetimes.format(fileCreateDate, "yyyyMMdd"));
            }
        }
        if (!"seeyon".equals(transType) || !AppContext.hasPlugin("seeyonOfficeTrans")) return false;
        if (fileId == 0L) {
            return this.writeStaticContentToBrower(fileId, fileName, request, response);
        }
        boolean transFlag = this.officeTransManager.isExist(fileId, dateStr);
        if (transFlag) {
            SeeyonOfficeTransManagerImpl seeyonOfficeTransManager = null;
            Object seeyonOfficeTransManagerObj = AppContext.getBean("seeyonOfficeTransManager");
            if (seeyonOfficeTransManagerObj == null) return false;
            seeyonOfficeTransManager = (SeeyonOfficeTransManagerImpl)seeyonOfficeTransManagerObj;
            File targetFile = seeyonOfficeTransManager.getFileForNewOfficeTrans(fileId, dateStr);
            String filePath = "";
            filePath = targetFile.getCanonicalPath();
            String extName = OfficeTransHelper.getExtName(filePath);
            String ServletPath = null;
            StringBuilder urlBuffer = new StringBuilder();
            if (FileType.DOCTYPES.contains(extName.toLowerCase()) || FileType.CODETYPES.contains(extName.toLowerCase())) {
                ServletPath = "/seeyon/officeTrans.do?method=toShow";
                String isMin = request.getParameter("isMin");
                isMin = "true";
                if (isMin != null && "true".equals(isMin.toLowerCase().trim())) {
                    ServletPath = "/seeyon/officeTrans.do?method=toMiniShow";
                }
                urlBuffer.append(ServletPath);
                urlBuffer.append("&fileId=").append(fileId);
                urlBuffer.append("&dateStr=").append(dateStr);
            } else {
                if (FileType.MSEXCELTYPES.contains(extName.toLowerCase())) {
                    return this.writeStaticContentToBrower(fileId, fileName, request, response);
                }
                if (FileType.VIDEOTYPES.contains(extName.toLowerCase()) || FileType.RADIOTYPES.contains(extName.toLowerCase()) || FileType.FLASHTYPES.contains(extName.toLowerCase()) || FileType.ZIPTYPES.contains(extName.toLowerCase()) || "dir".equals(extName.toLowerCase())) {
                    // empty if block
                }
            }
            this.redirect(response, urlBuffer.toString());
            return false;
        } else {
            Date fileCreateDate = Datetimes.parse(dateStr, "yyyyMMdd");
            this.officeTransManager.generate(fileId, fileCreateDate, true);
            this.redirect(response, "/seeyon/officeTrans.do?method=wait&fileId=" + fileId + "&fileCreateDate=" + Datetimes.format(fileCreateDate, "yyyyMMdd"));
        }
        return false;
    }

    private void redirect(HttpServletResponse response, String url) {
        response.addHeader("location", url);
        response.setStatus(302);
    }

    public void setOfficeTransManager(OfficeTransManager officeTransManager) {
        this.officeTransManager = officeTransManager;
    }
}

