/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.mq;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.mq.ActiveMQConsumer;
import com.seeyon.ctp.common.mq.ActiveMQProducer;
import com.seeyon.ctp.common.mq.Consummer;
import com.seeyon.ctp.common.mq.MQHandler;
import com.seeyon.ctp.common.mq.Producer;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;

public class MQProcessorFactory {
    public static synchronized Consummer generateConsumer(String mqType, String connUrl, String user, String password) throws BusinessException {
        ActiveMQConsumer consumer = null;
        if ("ActiveMQ".equals(mqType)) {
            try {
                ActiveMQConnectionFactory connectionFactory = null;
                connectionFactory = MQHandler.isEmbeddedServer ? new ActiveMQConnectionFactory(connUrl) : new ActiveMQConnectionFactory(connUrl, user, password);
                Connection connection = connectionFactory.createConnection();
                connection.start();
                Session session = connection.createSession(false, 1);
                Session manulAckSession = connection.createSession(false, 2);
                consumer = new ActiveMQConsumer().setAutoAckSession(session).setManualAckSession(manulAckSession);
                return consumer;
            }
            catch (JMSException e) {
                throw new BusinessException(e);
            }
        }
        return consumer;
    }

    public static synchronized Producer generateProducer(String mqType, String connUrl, String user, String password) throws BusinessException {
        ActiveMQProducer producer = null;
        if ("ActiveMQ".equals(mqType)) {
            try {
                ActiveMQConnectionFactory connectionFactory = null;
                connectionFactory = MQHandler.isEmbeddedServer ? new ActiveMQConnectionFactory(connUrl) : new ActiveMQConnectionFactory(connUrl, user, password);
                Connection connection = connectionFactory.createConnection();
                connection.start();
                Session session = connection.createSession(false, 1);
                Queue destination = session.createQueue("SEEYON.V5");
                MessageProducer activemqProducer = session.createProducer((Destination)destination);
                producer = new ActiveMQProducer().setSession(session).setRealProducer(activemqProducer);
            }
            catch (JMSException e) {
                throw new BusinessException(e);
            }
            return producer;
        }
        return producer;
    }
}

