/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.mq;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.mq.ChannelTypeEnum;
import com.seeyon.ctp.common.mq.Consummer;
import com.seeyon.ctp.common.mq.MapMessage;
import com.seeyon.ctp.common.mq.Message;
import com.seeyon.ctp.common.mq.MessageAckTypeEnum;
import com.seeyon.ctp.common.mq.MessageConsumeRunnable;
import com.seeyon.ctp.common.mq.MessageReceiver;
import com.seeyon.ctp.common.mq.ObjectMessage;
import com.seeyon.ctp.common.mq.TextMessage;
import java.util.HashMap;
import java.util.concurrent.RejectedExecutionException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.commons.logging.Log;

public class ActiveMQConsumer
extends Consummer {
    private static final Log logger = CtpLogFactory.getLog(ActiveMQConsumer.class);
    private Session manualAckSession;
    private Session autoAckSession;

    public ActiveMQConsumer setManualAckSession(Session manualAckSession) {
        this.manualAckSession = manualAckSession;
        return this;
    }

    public ActiveMQConsumer setAutoAckSession(Session autoAckSession) {
        this.autoAckSession = autoAckSession;
        return this;
    }

    @Override
    public void subscribe(final MessageAckTypeEnum ackType, ChannelTypeEnum channelTypeEnum, String channel, final MessageReceiver receiver) throws BusinessException {
        Object destination = null;
        Session session = null;
        session = MessageAckTypeEnum.AUTO_ACK.equals((Object)ackType) ? this.autoAckSession : this.manualAckSession;
        try {
            destination = channelTypeEnum.equals((Object)ChannelTypeEnum.QUEUE) ? session.createQueue(channel) : session.createTopic(channel);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(javax.jms.Message message) {
                    Message msg = null;
                    try {
                        msg = this.dressMessage(message);
                        if (!MessageAckTypeEnum.AUTO_ACK.equals((Object)ackType)) {
                            if (msg != null) {
                                msg.setOriginMsg(message);
                            } else {
                                logger.error((Object)"msg is null");
                            }
                        }
                        ActiveMQConsumer.this.threadPoolExecutor.execute(new MessageConsumeRunnable(receiver, msg));
                    }
                    catch (JMSException e) {
                        logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        try {
                            message.acknowledge();
                        }
                        catch (JMSException e1) {
                            logger.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
                        }
                    }
                    catch (RejectedExecutionException e) {
                        if (msg != null) {
                            logger.error((Object)("reject message handler , " + msg.getChannel() + "." + msg.getKey()));
                        }
                        try {
                            message.acknowledge();
                        }
                        catch (JMSException e1) {
                            logger.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
                        }
                    }
                }

                private Message dressMessage(javax.jms.Message msg) throws JMSException {
                    Message message = null;
                    if (msg instanceof javax.jms.TextMessage) {
                        javax.jms.TextMessage realMsg = (javax.jms.TextMessage)msg;
                        message = new TextMessage(realMsg.getText());
                        message.setKey(realMsg.getStringProperty("key"));
                    } else if (msg instanceof javax.jms.ObjectMessage) {
                        javax.jms.ObjectMessage realMsg = (javax.jms.ObjectMessage)msg;
                        message = realMsg.getObject() instanceof HashMap ? new MapMessage((HashMap)realMsg.getObject()) : new ObjectMessage(realMsg.getObject());
                        message.setKey(realMsg.getStringProperty("key"));
                    }
                    return message;
                }
            });
        }
        catch (JMSException e) {
            throw new BusinessException(e);
        }
    }
}

