/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata.manager;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.metadata.bo.MetadataTableTreeBO;
import com.seeyon.ctp.common.metadata.dao.MetadataTableDao;
import com.seeyon.ctp.common.metadata.manager.MetadataTableManager;
import com.seeyon.ctp.common.metadata.util.ConvertMetadataUtil;
import com.seeyon.ctp.common.po.metadata.CtpMetadataTable;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.ParamUtil;
import java.util.List;
import java.util.Map;

@ProcessInDataSource(name=DataSourceName.BASE)
public class MetadataTableManagerImpl
implements MetadataTableManager {
    private MetadataTableDao metadataTableDao;

    @Override
    public List<MetadataTableTreeBO> findCtpMetadataTableListToTree(Map<String, Object> params) throws BusinessException {
        Integer applicationCategory = ParamUtil.getInt(params, "applicationCategory");
        String parentNodeName = ParamUtil.getString(params, "parentNodeName");
        List<CtpMetadataTable> ctpMetadataTableList = this.metadataTableDao.findCtpMetadataTableListByApplicationCategory(applicationCategory);
        List<MetadataTableTreeBO> metadataTableTreeBOList = ConvertMetadataUtil.convertCtpMetadataTableToTreeBOList(ctpMetadataTableList);
        this.fillMetadataTableTreeBOListParentNode(metadataTableTreeBOList, parentNodeName);
        return metadataTableTreeBOList;
    }

    @Override
    public CtpMetadataTable getByName(String name) throws BusinessException {
        return this.metadataTableDao.findCtpMetadataTableByTableName(name);
    }

    @Override
    public CtpMetadataTable getById(Long Id) throws BusinessException {
        CtpMetadataTable ctpMetadataTable = null;
        if (Id != null) {
            ctpMetadataTable = this.metadataTableDao.getCtpMetadataTableById(Id);
        }
        return ctpMetadataTable;
    }

    private void fillMetadataTableTreeBOListParentNode(List<MetadataTableTreeBO> metadataTableTreeBOList, String parentNodeName) {
        if (metadataTableTreeBOList != null) {
            MetadataTableTreeBO metadataTableTreeBO = new MetadataTableTreeBO();
            metadataTableTreeBO.setId(-1L);
            metadataTableTreeBO.setTableName(parentNodeName);
            metadataTableTreeBO.setParentId(-1L);
            metadataTableTreeBOList.add(metadataTableTreeBO);
        }
    }

    public void setMetadataTableDao(MetadataTableDao metadataTableDao) {
        this.metadataTableDao = metadataTableDao;
    }
}

