/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata.dao;

import com.seeyon.ctp.common.dao.BaseHibernateDao;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.metadata.dao.MetadataCategoryDao;
import com.seeyon.ctp.common.metadata.util.HqlBuildUtil;
import com.seeyon.ctp.common.po.metadata.CtpMetadataCategory;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MetadataCategoryDaoImpl
extends BaseHibernateDao<CtpMetadataCategory>
implements MetadataCategoryDao {
    public static final String CTP_METADATA_CATEGORY_ALIAS = "cmg";

    @Override
    public CtpMetadataCategory getById(Long id) throws BusinessException {
        return (CtpMetadataCategory)super.get(id);
    }

    @Override
    public List<CtpMetadataCategory> getCategoryList(FlipInfo fi, Map<String, Object> sqlParams) throws BusinessException {
        StringBuilder hqlStr = new StringBuilder();
        hqlStr.append(HqlBuildUtil.getTableQueryHql(CtpMetadataCategory.class.getName(), null, CTP_METADATA_CATEGORY_ALIAS, null));
        this.buildQueryCtpMetadataCategoryConditionHql(hqlStr, sqlParams);
        hqlStr.append(" order by ").append(CTP_METADATA_CATEGORY_ALIAS).append(".createTime asc");
        List categoryList = DBAgent.find(hqlStr.toString(), sqlParams, fi);
        return categoryList;
    }

    @Override
    public Long createCtpMetadataCategory(CtpMetadataCategory ctpMetadataCategory) throws BusinessException {
        Long id = -1L;
        if (ctpMetadataCategory != null) {
            id = (Long)DBAgent.save(ctpMetadataCategory);
        }
        return id;
    }

    @Override
    public void updateCtpMetadataCategory(CtpMetadataCategory ctpMetadataCategory) throws BusinessException {
        if (ctpMetadataCategory != null) {
            DBAgent.update(ctpMetadataCategory);
        }
    }

    @Override
    public void deleteCategory(List<Long> idList) throws BusinessException {
        StringBuilder hqlSbr = new StringBuilder();
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(idList)) {
            hqlSbr.append("DELETE FROM ").append(CtpMetadataCategory.class.getCanonicalName());
            hqlSbr.append(" WHERE id in (:idList)");
            sqlParams.put("idList", idList);
            DBAgent.bulkUpdate(hqlSbr.toString(), sqlParams);
        }
    }

    private void buildQueryCtpMetadataCategoryConditionHql(StringBuilder hqlStr, Map<String, Object> sqlParams) {
        if (hqlStr != null && hqlStr.length() != 0 && MapUtils.isNotEmpty(sqlParams)) {
            for (String key : sqlParams.keySet()) {
                boolean isWhere = hqlStr.toString().indexOf("where") < 0;
                hqlStr.append(HqlBuildUtil.buildConditionHql(isWhere, CTP_METADATA_CATEGORY_ALIAS, "=", key));
            }
        }
    }

    @Override
    public List<CtpMetadataCategory> findAll() {
        return super.getAll();
    }
}

