/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.log;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Datetimes;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class RollingDailyFileAppender
extends FileAppender {
    private String datePattern = "'.'yyyy-MM-dd";
    private long maxFileSize = 0xA00000L;
    private GregorianCalendar lastCheck = new GregorianCalendar();
    private int maxBackupDay = 10;
    private static final Log LOG = CtpLogFactory.getLog(RollingDailyFileAppender.class);

    public RollingDailyFileAppender() {
    }

    public RollingDailyFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public int getMaxBackupDay() {
        return this.maxBackupDay;
    }

    public void setMaxBackupDay(int maxBackupDay) {
        this.maxBackupDay = maxBackupDay;
    }

    public void activateOptions() {
        super.activateOptions();
        File f = new File(this.fileName);
        if (f.exists()) {
            this.lastCheck.setTimeInMillis(f.lastModified());
        }
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
        if (append) {
            File f = new File(fileName);
            ((CountingQuietWriter)this.qw).setCount(f.length());
        }
    }

    private void rollOver() throws IOException {
        Date now = this.lastCheck.getTime();
        int maxFileNumber = this.getMaxFileNumber(now);
        File target = new File(this.fileName + Datetimes.format(now, this.datePattern) + "." + (maxFileNumber + 1) + ".log");
        this.closeFile();
        File file = new File(this.fileName);
        final String fileNameOld = file.getName();
        boolean rnSucc = file.renameTo(target);
        if (!rnSucc) {
            try {
                FileUtils.copyFile((File)file, (File)target);
                file.delete();
            }
            catch (IOException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)(new Date() + " setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
        File logDir = file.getParentFile();
        File[] logFiles = logDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(fileNameOld) && name.length() > fileNameOld.length();
            }
        });
        if (logFiles.length > 0) {
            for (File logFile : logFiles) {
                String logFileName = logFile.getName();
                String logFileDateStr = logFileName.substring(fileNameOld.length(), fileNameOld.length() + 11);
                try {
                    Date logFileDate = Datetimes.parse(logFileDateStr, this.datePattern);
                    if (System.currentTimeMillis() - logFileDate.getTime() <= 86400000L) continue;
                    File dereict = new File(logFile.getParent() + File.separator + logFileDateStr.substring(1));
                    if (!dereict.exists()) {
                        dereict.mkdirs();
                    }
                    File targetFile = new File(dereict.getAbsolutePath() + File.separator + logFile.getName());
                    int i = 1;
                    while (targetFile.exists()) {
                        String targetFileName = logFile.getName().substring(0, logFile.getName().length() - 4) + "_" + i++ + ".log";
                        targetFile = new File(dereict.getAbsolutePath() + File.separator + targetFileName);
                    }
                    rnSucc = logFile.renameTo(targetFile);
                    if (rnSucc) continue;
                    try {
                        FileUtils.copyFile((File)logFile, (File)targetFile);
                        logFile.delete();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    LogLog.error((String)(new Date() + "renameTo failed."), (Throwable)e);
                }
            }
        }
    }

    private int getMaxFileNumber(Date date) {
        String d = Datetimes.format(date, this.datePattern);
        int number = 1;
        File target;
        while ((target = new File(this.fileName + d + "." + number + ".log")).exists()) {
            ++number;
        }
        return number - 1;
    }

    protected void subAppend(LoggingEvent event) {
        GregorianCalendar c = new GregorianCalendar();
        if (this.lastCheck.get(6) != c.get(6) || ((CountingQuietWriter)this.qw).getCount() >= this.maxFileSize) {
            try {
                this.rollOver();
            }
            catch (Exception ioe) {
                LogLog.error((String)(new Date() + "rollOver() failed."), (Throwable)ioe);
            }
            this.lastCheck = c;
        }
        super.subAppend(event);
    }
}

