/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.log;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;

public class Log4JConfigurator {
    private static final Log LOG = CtpLogFactory.getLog(Log4JConfigurator.class);
    private static LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);

    public static LoggerContext getContext() {
        return context;
    }

    public static void initialize() {
        try {
            String filePath = AppContext.getCfgHome().getAbsolutePath() + "/base/log4j2_sys_starting.xml";
            Log4JConfigurator.initConfig(filePath);
            Log4JConfigurator.reloadConfig(filePath);
            LOG.info((Object)"Application logging configured");
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return;
        }
    }

    public static void startDevLog() {
    }

    public static void reInitialized() {
        try {
            String filePath = AppContext.getCfgHome().getAbsolutePath() + "/base/log4j2_sys_running.xml";
            Log4JConfigurator.reloadConfig(filePath);
            LOG.info((Object)"logging re-configured");
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public static void initConfig(String filePath) throws FileNotFoundException {
        File file = new File(filePath);
        ConfigurationSource source = new ConfigurationSource((InputStream)new FileInputStream(file), file);
        Configurator.initialize(null, (ConfigurationSource)source);
    }

    public static void reloadConfig(String filePath) {
        File file = new File(filePath);
        context.setConfigLocation(file.toURI());
        context.reconfigure();
    }
}

