/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.ipcontrol;

import com.seeyon.ctp.common.authenticate.domain.IP;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.cache.CacheSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IpcontrolUserManager {
    private static final CacheAccessable cacheFactory = CacheFactory.getInstance(IpcontrolUserManager.class);
    private CacheSet<Long> noLimitIp = cacheFactory.createSet("NoLimitIp");
    private CacheSet<IP> blackListIp = cacheFactory.createSet("blackListIp");
    private CacheMap<Long, ArrayList<IP>> limitIp = cacheFactory.createMap("LimitIp");
    private static IpcontrolUserManager instance = new IpcontrolUserManager();

    public static IpcontrolUserManager getInstance() {
        return instance;
    }

    public void addNoLimitIp(Set<Long> loginNames) {
        this.noLimitIp.replaceAll(loginNames);
    }

    public void addLimitIp(Map<Long, List<IP>> limits) {
        this.limitIp.replaceAll(limits);
    }

    public void addBlackListIp(HashSet<IP> blackListIp) {
        this.blackListIp.replaceAll(blackListIp);
    }

    public Set<IP> getBlackListIp() {
        return this.blackListIp.toSet();
    }

    public Set<Long> getNoLimitIp() {
        return this.noLimitIp.toSet();
    }

    public Map<Long, List<IP>> getLimitIp() {
        return this.limitIp.toMap();
    }
}

